/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.AbstractBasicBuilder;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.StandardHttpHeaders;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class StandardHttpRequest
extends StandardHttpHeaders
implements HttpRequest {
    public static final String METHOD_POST = "POST";
    private final UUID id = UUID.randomUUID();
    private final URI uri;
    private final String method;
    private final String contentType;
    private final String bodyString;
    private final BodyContent body;
    private final boolean expectContinue;

    public StandardHttpRequest(Map<String, List<String>> headers, URI uri, String method, String bodyString) {
        this(headers, uri, method, bodyString, null, false, null);
    }

    StandardHttpRequest(Map<String, List<String>> headers, URI uri, String method, String bodyString, BodyContent body, boolean expectContinue, String contentType) {
        super(headers);
        this.uri = uri;
        this.method = method;
        this.bodyString = bodyString;
        this.body = body;
        this.expectContinue = expectContinue;
        this.contentType = contentType;
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public String bodyString() {
        return this.bodyString;
    }

    public BodyContent body() {
        return this.body;
    }

    public boolean isExpectContinue() {
        return this.expectContinue;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static final class Builder
    extends AbstractBasicBuilder<Builder>
    implements HttpRequest.Builder {
        private String method = "GET";
        private BodyContent body;
        private String bodyAsString;
        private boolean expectContinue;
        private String contentType;

        public Builder() {
        }

        public Builder(StandardHttpRequest original) {
            super.uri(original.uri());
            super.setHeaders(original.headers());
            this.method = original.method;
            this.bodyAsString = original.bodyString;
            this.body = original.body;
            this.expectContinue = original.expectContinue;
            this.contentType = original.contentType;
        }

        @Override
        public StandardHttpRequest build() {
            return new StandardHttpRequest(this.getHeaders(), Objects.requireNonNull(this.getUri()), this.method, this.bodyAsString, this.body, this.expectContinue, this.contentType);
        }

        @Override
        public HttpRequest.Builder uri(String uri) {
            return (HttpRequest.Builder)super.uri(URI.create(uri));
        }

        @Override
        public HttpRequest.Builder url(URL url) {
            try {
                return (HttpRequest.Builder)super.uri(url.toURI());
            }
            catch (URISyntaxException e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }

        @Override
        public HttpRequest.Builder post(String contentType, byte[] writeValueAsBytes) {
            this.method = StandardHttpRequest.METHOD_POST;
            this.contentType = contentType;
            this.body = new ByteArrayBodyContent(writeValueAsBytes);
            return this;
        }

        @Override
        public HttpRequest.Builder post(String contentType, InputStream stream, long length) {
            this.method = StandardHttpRequest.METHOD_POST;
            this.contentType = contentType;
            this.body = new InputStreamBodyContent(stream, length);
            return this;
        }

        @Override
        public HttpRequest.Builder method(String method, String contentType, String body) {
            this.method = method;
            this.contentType = contentType;
            this.bodyAsString = body;
            if (body != null) {
                this.body = new StringBodyContent(body);
            }
            return this;
        }

        @Override
        public HttpRequest.Builder expectContinue() {
            this.expectContinue = true;
            return this;
        }
    }

    public static class InputStreamBodyContent
    implements BodyContent {
        private long length;
        private InputStream content;

        public InputStreamBodyContent(InputStream stream, long length) {
            this.length = length;
            this.content = stream;
        }

        public InputStream getContent() {
            return this.content;
        }

        public long getLength() {
            return this.length;
        }
    }

    public static class ByteArrayBodyContent
    implements BodyContent {
        private byte[] content;

        public ByteArrayBodyContent(byte[] bytes) {
            this.content = bytes;
        }

        public byte[] getContent() {
            return this.content;
        }
    }

    public static class StringBodyContent
    implements BodyContent {
        private String content;

        public StringBodyContent(String content) {
            this.content = content;
        }

        public String getContent() {
            return this.content;
        }
    }

    public static interface BodyContent {
    }
}

