/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.pipelines;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.environments.Environments;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.pipelines.JobEnvironment;
import io.fabric8.kubernetes.api.pipelines.Pipeline;
import io.fabric8.kubernetes.api.pipelines.PipelineKind;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.utils.Strings;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineConfiguration {
    private static final transient Logger LOG = LoggerFactory.getLogger(PipelineConfiguration.class);
    public static final String FABRIC8_PIPELINES = "fabric8-pipelines";
    public static final String CI_BRANCH_PATTERNS = "ci-branch-patterns";
    public static final String CD_BRANCH_PATTERNS = "cd-branch-patterns";
    public static final String ORGANISATION_BRANCH_PATTERNS = "organisation-branch-patterns";
    public static final String JOB_NAME_TO_KIND = "job-name-to-kind";
    public static final String DISABLE_CD_ITESTS = "disable-itests-cd";
    public static final String DISABLE_CI_ITESTS = "disable-itests-ci";
    public static final String USE_DOCKER_SOCKET = "use-docker-socket";
    private Map<String, PipelineKind> jobNameToKindMap = new HashMap<String, PipelineKind>();
    private List<String> ciBranchPatterns = new ArrayList<String>();
    private List<String> cdBranchPatterns = new ArrayList<String>();
    private Map<String, List<String>> cdGitHostAndOrganisationToBranchPatterns = new HashMap<String, List<String>>();
    private boolean disableITestsCD;
    private boolean disableITestsCI;
    private boolean useDockerSocket;
    private String spaceNamespace;

    public PipelineConfiguration() {
    }

    public PipelineConfiguration(Map<String, String> configMapData) {
        String valueText;
        this.ciBranchPatterns = this.loadYamlListOfStrings(configMapData, CI_BRANCH_PATTERNS);
        this.cdBranchPatterns = this.loadYamlListOfStrings(configMapData, CD_BRANCH_PATTERNS);
        this.disableITestsCD = this.loadYamlBoolean(configMapData, DISABLE_CD_ITESTS, false);
        this.disableITestsCI = this.loadYamlBoolean(configMapData, DISABLE_CI_ITESTS, false);
        this.useDockerSocket = this.loadYamlBoolean(configMapData, USE_DOCKER_SOCKET, true);
        Map<Object, Object> orgBranchMap = this.loadYamlMap(configMapData, ORGANISATION_BRANCH_PATTERNS);
        for (Map.Entry<Object, Object> entry : orgBranchMap.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(key instanceof String)) continue;
            String keyText = (String)key;
            ArrayList<String> list = null;
            if (value instanceof List) {
                list = (ArrayList<String>)value;
            } else if (value != null) {
                valueText = value.toString();
                list = new ArrayList<String>();
                list.add(valueText);
            }
            if (list != null) {
                this.cdGitHostAndOrganisationToBranchPatterns.put(keyText, list);
                continue;
            }
            LOG.warn("Could not find List for organisation-branch-patterns key " + key + " value: " + value);
        }
        Map<Object, Object> jobNameMap = this.loadYamlMap(configMapData, JOB_NAME_TO_KIND);
        for (Map.Entry<Object, Object> entry : jobNameMap.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            String keyText = key.toString();
            valueText = value.toString();
            try {
                PipelineKind pipelineKind = PipelineKind.valueOf(valueText);
                this.jobNameToKindMap.put(keyText, pipelineKind);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Ignoring job-name-to-kind key " + key + " with value: " + value + ". Values are: " + Arrays.asList(PipelineKind.values()) + ". " + e, (Throwable)e);
            }
        }
    }

    public static PipelineConfiguration createDefault() {
        PipelineConfiguration configuration = new PipelineConfiguration();
        configuration.getCiBranchPatterns().add("PR-.*");
        return configuration;
    }

    public static String getGitHostOrganisationString(String gitUrl) {
        String text;
        String text2;
        int idx;
        if (Strings.isNullOrBlank((String)gitUrl)) {
            return null;
        }
        String prefix = "git@";
        if (gitUrl.startsWith(prefix) && (idx = (text2 = gitUrl.substring(prefix.length())).indexOf(47)) > 0) {
            return text2.substring(0, idx).replace(':', '/');
        }
        String schemeSuffix = "://";
        idx = gitUrl.indexOf(schemeSuffix);
        if (idx > 0 && (idx = (text = gitUrl.substring(idx + schemeSuffix.length())).indexOf("/")) > 0 && (idx = text.indexOf("/", idx + 1)) > 0) {
            return text.substring(0, idx);
        }
        return null;
    }

    public static PipelineConfiguration loadPipelineConfiguration() {
        try (DefaultKubernetesClient kubernetesClient = new DefaultKubernetesClient();){
            String namespace = Environments.findSpaceNamespace((KubernetesClient)kubernetesClient);
            PipelineConfiguration pipelineConfiguration = PipelineConfiguration.loadPipelineConfiguration((KubernetesClient)kubernetesClient, namespace);
            return pipelineConfiguration;
        }
    }

    public static PipelineConfiguration loadPipelineConfiguration(String namespace) {
        try (DefaultKubernetesClient kubernetesClient = new DefaultKubernetesClient();){
            PipelineConfiguration pipelineConfiguration = PipelineConfiguration.loadPipelineConfiguration((KubernetesClient)kubernetesClient, namespace);
            return pipelineConfiguration;
        }
    }

    public static PipelineConfiguration loadPipelineConfiguration(KubernetesClient kubernetesClient, String namespace) {
        ConfigMap configMap = (ConfigMap)((Resource)((NonNamespaceOperation)kubernetesClient.configMaps().inNamespace(namespace)).withName(FABRIC8_PIPELINES)).get();
        PipelineConfiguration configuration = configMap != null ? PipelineConfiguration.getPipelineConfiguration(configMap) : PipelineConfiguration.createDefault();
        configuration.setSpaceNamespace(namespace);
        return configuration;
    }

    public static void savePipelineConfiguration(KubernetesClient kubernetesClient, String namespace, PipelineConfiguration configuration) {
        ConfigMap configMap = configuration.createConfigMap();
        ((Resource)((NonNamespaceOperation)kubernetesClient.configMaps().inNamespace(namespace)).withName(FABRIC8_PIPELINES)).createOrReplace((Object[])new ConfigMap[]{configMap});
    }

    public String toString() {
        return "PipelineConfiguration{jobNameToKindMap=" + this.jobNameToKindMap + ", ciBranchPatterns=" + this.ciBranchPatterns + ", cdBranchPatterns=" + this.cdBranchPatterns + ", cdGitHostAndOrganisationToBranchPatterns=" + this.cdGitHostAndOrganisationToBranchPatterns + ", disableITestsCD=" + this.disableITestsCD + ", disableITestsCI=" + this.disableITestsCI + '}';
    }

    public ConfigMap createConfigMap() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(JOB_NAME_TO_KIND, this.asYaml(this.jobNameToKindMap));
        data.put(CI_BRANCH_PATTERNS, this.asYaml(this.ciBranchPatterns));
        data.put(CD_BRANCH_PATTERNS, this.asYaml(this.cdBranchPatterns));
        data.put(ORGANISATION_BRANCH_PATTERNS, this.asYaml(this.cdGitHostAndOrganisationToBranchPatterns));
        return ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(FABRIC8_PIPELINES)).addToLabels("provider", "fabric8")).endMetadata()).withData(data)).build();
    }

    private String asYaml(Object value) {
        if (value != null) {
            try {
                return KubernetesHelper.toYaml(value);
            }
            catch (IOException e) {
                LOG.warn("Error trying to convert " + value + " to YAML: " + e, (Throwable)e);
            }
        }
        return "";
    }

    public static PipelineConfiguration getPipelineConfiguration(ConfigMap configMap) {
        HashMap<String, String> data = configMap.getData();
        if (data == null) {
            data = new HashMap<String, String>();
        }
        return new PipelineConfiguration(data);
    }

    private Map<Object, Object> loadYamlMap(Map<String, String> configMapData, String key) {
        String text = configMapData.get(key);
        if (Strings.isNotBlank((String)text)) {
            try {
                return KubernetesHelper.loadYaml(text, Map.class);
            }
            catch (IOException e) {
                LOG.warn("Failed to read key " + key + " with text " + text + " due to: " + e, (Throwable)e);
            }
        }
        return Collections.EMPTY_MAP;
    }

    private List<String> loadYamlListOfStrings(Map<String, String> configMapData, String key) {
        ArrayList<String> answer = new ArrayList<String>();
        String text = configMapData.get(key);
        if (Strings.isNotBlank((String)text)) {
            try {
                List list = KubernetesHelper.loadYaml(text, List.class);
                for (Object value : list) {
                    if (!(value instanceof String)) continue;
                    String textValue = (String)value;
                    answer.add(textValue);
                }
            }
            catch (IOException e) {
                LOG.warn("Failed to read key " + key + " with text " + text + " due to: " + e, (Throwable)e);
            }
        }
        return answer;
    }

    private boolean loadYamlBoolean(Map<String, String> configMapData, String key, boolean defaultValue) {
        String text = configMapData.get(key);
        if (Strings.isNotBlank((String)text)) {
            return text.equalsIgnoreCase("true");
        }
        return defaultValue;
    }

    public Map<String, PipelineKind> getJobNameToKindMap() {
        return this.jobNameToKindMap;
    }

    public List<String> getCiBranchPatterns() {
        return this.ciBranchPatterns;
    }

    public List<String> getCdBranchPatterns() {
        return this.cdBranchPatterns;
    }

    public boolean isUseDockerSocket() {
        return this.useDockerSocket;
    }

    public void setUseDockerSocket(boolean useDockerSocket) {
        this.useDockerSocket = useDockerSocket;
    }

    public Map<String, List<String>> getCdGitHostAndOrganisationToBranchPatterns() {
        return this.cdGitHostAndOrganisationToBranchPatterns;
    }

    public void setJobNameToKindMap(Map<String, PipelineKind> jobNameToKindMap) {
        this.jobNameToKindMap = jobNameToKindMap;
    }

    public void setCiBranchPatterns(List<String> ciBranchPatterns) {
        this.ciBranchPatterns = ciBranchPatterns;
    }

    public void setCdBranchPatterns(List<String> cdBranchPatterns) {
        this.cdBranchPatterns = cdBranchPatterns;
    }

    public void setCdGitHostAndOrganisationToBranchPatterns(Map<String, List<String>> cdGitHostAndOrganisationToBranchPatterns) {
        this.cdGitHostAndOrganisationToBranchPatterns = cdGitHostAndOrganisationToBranchPatterns;
    }

    public boolean isDisableITestsCD() {
        return this.disableITestsCD;
    }

    public void setDisableITestsCD(boolean disableITestsCD) {
        this.disableITestsCD = disableITestsCD;
    }

    public boolean isDisableITestsCI() {
        return this.disableITestsCI;
    }

    public void setDisableITestsCI(boolean disableITestsCI) {
        this.disableITestsCI = disableITestsCI;
    }

    public Pipeline getPipeline(Map<String, String> jobEnvironmentMap) throws IntrospectionException {
        JobEnvironment jobEnvironment = JobEnvironment.create(jobEnvironmentMap);
        Pipeline pipeline = this.getPipeline(jobEnvironment);
        pipeline.setConfiguration(this);
        return pipeline;
    }

    public PipelineConfiguration setJobNamesCD(String ... names) {
        return this.setJobNamesKind(PipelineKind.CD, names);
    }

    public PipelineConfiguration setJobNamesCI(String ... names) {
        return this.setJobNamesKind(PipelineKind.CI, names);
    }

    public PipelineConfiguration setJobNamesDeveloper(String ... names) {
        return this.setJobNamesKind(PipelineKind.Developer, names);
    }

    public PipelineConfiguration setJobNamesKind(PipelineKind kind, String ... names) {
        for (String name : names) {
            this.jobNameToKindMap.put(name, kind);
        }
        return this;
    }

    public PipelineConfiguration setCDGitOrganisation(String gitHostAndOrganisation, String ... branchPatterns) {
        return this.setCDGitOrganisation(gitHostAndOrganisation, Arrays.asList(branchPatterns));
    }

    public PipelineConfiguration setCDGitOrganisation(String gitHostAndOrganisation, List<String> branchPatterns) {
        if (branchPatterns.isEmpty()) {
            throw new IllegalArgumentException("You must specify at least one branch pattern for github host and organisation: " + gitHostAndOrganisation);
        }
        this.cdGitHostAndOrganisationToBranchPatterns.put(gitHostAndOrganisation, branchPatterns);
        return this;
    }

    public Pipeline getPipeline(JobEnvironment jobEnvironment) {
        String jobName = jobEnvironment.getJobName();
        PipelineKind kind = this.jobNameToKindMap.get(jobName);
        if (kind != null) {
            return new Pipeline(kind, jobName);
        }
        String branchName = jobEnvironment.getBranchName();
        kind = PipelineKind.Developer;
        if (Strings.isNullOrBlank((String)branchName)) {
            LOG.warn("No BranchName from the environment so cannot detect CI / PR jobs!");
        } else {
            List<String> branchPatterns;
            String hostOrganisation;
            String gitUrl = jobEnvironment.getGitUrl();
            if (Strings.isNotBlank((String)gitUrl) && Strings.isNotBlank((String)(hostOrganisation = PipelineConfiguration.getGitHostOrganisationString(gitUrl))) && (branchPatterns = this.cdGitHostAndOrganisationToBranchPatterns.get(hostOrganisation)) != null && this.matchesPattern(branchName, branchPatterns)) {
                return new Pipeline(PipelineKind.CD, jobName);
            }
            if (this.matchesPattern(branchName, this.ciBranchPatterns)) {
                kind = PipelineKind.CI;
            } else if (this.matchesPattern(branchName, this.cdBranchPatterns)) {
                kind = PipelineKind.CD;
            }
        }
        return new Pipeline(kind, jobName);
    }

    protected boolean matchesPattern(String text, List<String> listOfPatterns) {
        for (String pattern : listOfPatterns) {
            if (!text.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    public void setSpaceNamespace(String spaceNamespace) {
        this.spaceNamespace = spaceNamespace;
    }

    public String getSpaceNamespace() {
        return this.spaceNamespace;
    }
}

