/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.cfg.Annotations;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import io.fabric8.kubernetes.api.ExceptionResponseMapper;
import io.fabric8.kubernetes.api.Kubernetes;
import io.fabric8.kubernetes.api.KubernetesExtensions;
import io.fabric8.kubernetes.api.KubernetesGlobalExtensions;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.extensions.Configs;
import io.fabric8.kubernetes.api.model.AuthInfo;
import io.fabric8.kubernetes.api.model.Cluster;
import io.fabric8.kubernetes.api.model.Config;
import io.fabric8.kubernetes.api.model.Context;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import io.fabric8.utils.cxf.AuthorizationHeaderFilter;
import io.fabric8.utils.cxf.WebClients;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesFactory {
    public static final String KUBERNETES_SCHEMA_JSON = "schema/kube-schema.json";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String KUBERNETES_TRUST_ALL_CERIFICATES = "KUBERNETES_TRUST_CERT";
    public static final String KUBERNETES_DISABLE_HOSTNAME_CHECK = "KUBERNETES_DISABLE_HOSTNAME_CHECK";
    public static final String KUBERNETES_SERVICE_HOST_ENV_VAR = "KUBERNETES_SERVICE_HOST";
    public static final String KUBERNETES_SERVICE_PORT_ENV_VAR = "KUBERNETES_SERVICE_PORT";
    public static final String KUBERNETES_MASTER_ENV_VAR = "KUBERNETES_MASTER";
    public static final String KUBERNETES_CA_CERTIFICATE_FILE_ENV_VAR = "KUBERNETES_CA_CERTIFICATE_FILE";
    public static final String KUBERNETES_CLIENT_CERTIFICATE_FILE_ENV_VAR = "KUBERNETES_CLIENT_CERTIFICATE_FILE";
    public static final String KUBERNETES_CLIENT_KEY_FILE_ENV_VAR = "KUBERNETES_CLIENT_KEY_FILE";
    public static final String KUBERNETES_CLIENT_KEY_DATA_ENV_VAR = "KUBERNETES_CLIENT_KEY_DATA";
    public static final String KUBERNETES_CA_CERTIFICATE_DATA_ENV_VAR = "KUBERNETES_CA_CERTIFICATE_DATA";
    public static final String KUBERNETES_CLIENT_CERTIFICATE_DATA_ENV_VAR = "KUBERNETES_CLIENT_CERTIFICATE_DATA";
    public static final String KUBERNETES_CLIENT_KEY_ALGO_ENV_VAR = "KUBERNETES_CLIENT_KEY_ALGO";
    public static final String KUBERNETES_CLIENT_KEY_PASSWORD_ENV_VAR = "KUBERNETES_CLIENT_KEY_PASSWORD";
    public static final String KUBERNETES_MASTER_SYSTEM_PROPERTY = "kubernetes.master";
    public static final String KUBERNETES_VERIFY_SYSTEM_PROPERTY = "kubernetes.verify";
    private String address;
    private boolean verifyAddress = true;
    private boolean trustAllCerts = false;
    private boolean disableHostNameChecks = false;
    private File caCertFile;
    private File clientCertFile;
    private File clientKeyFile;
    private String caCertData;
    private String clientCertData;
    private String clientKeyData;
    private String clientKeyAlgo = "RSA";
    private char[] clientKeyPassword = "changeit".toCharArray();
    private String username;
    private String password;

    public KubernetesFactory() {
        this(null);
    }

    public KubernetesFactory(String address) {
        this(address, Boolean.parseBoolean(System.getProperty(KUBERNETES_VERIFY_SYSTEM_PROPERTY, "true")));
    }

    public KubernetesFactory(String address, boolean verifyAddress) {
        this.verifyAddress = verifyAddress;
        this.init(address);
    }

    protected String findKubernetesMaster() {
        return KubernetesFactory.resolveHttpKubernetesMaster();
    }

    private void init(String address) {
        if (Strings.isNullOrBlank((String)address)) {
            String kubeAddress = this.findKubernetesMaster();
            if (kubeAddress != null) {
                this.setAddress(kubeAddress);
            } else {
                this.configureFromKubeConfig();
            }
        } else {
            this.setAddress(address);
        }
        if (Systems.hasEnvVarOrSystemProperty((String)KUBERNETES_TRUST_ALL_CERIFICATES)) {
            this.trustAllCerts = Systems.getEnvVarOrSystemProperty((String)KUBERNETES_TRUST_ALL_CERIFICATES, (Boolean)false);
        } else if (Systems.hasEnvVarOrSystemProperty((String)KUBERNETES_CA_CERTIFICATE_FILE_ENV_VAR)) {
            File candidateCaCertFile = new File(Systems.getEnvVarOrSystemProperty((String)KUBERNETES_CA_CERTIFICATE_FILE_ENV_VAR));
            if (candidateCaCertFile.exists() && candidateCaCertFile.canRead()) {
                this.caCertFile = candidateCaCertFile;
            } else {
                this.log.error("Specified CA certificate file {} does not exist or is not readable", (Object)candidateCaCertFile);
            }
        }
        if (Systems.hasEnvVarOrSystemProperty((String)KUBERNETES_DISABLE_HOSTNAME_CHECK)) {
            this.disableHostNameChecks = Systems.getEnvVarOrSystemProperty((String)KUBERNETES_DISABLE_HOSTNAME_CHECK, (Boolean)false);
        }
        if (Systems.hasEnvVarOrSystemProperty((String)KUBERNETES_CA_CERTIFICATE_DATA_ENV_VAR)) {
            this.caCertData = Systems.getEnvVarOrSystemProperty((String)KUBERNETES_CA_CERTIFICATE_DATA_ENV_VAR);
        }
        if (Systems.hasEnvVarOrSystemProperty((String)KUBERNETES_CLIENT_CERTIFICATE_FILE_ENV_VAR)) {
            File candidateClientCertFile = new File(Systems.getEnvVarOrSystemProperty((String)KUBERNETES_CLIENT_CERTIFICATE_FILE_ENV_VAR));
            if (candidateClientCertFile.exists() && candidateClientCertFile.canRead()) {
                this.clientCertFile = candidateClientCertFile;
            } else {
                this.log.error("Specified client certificate file {} does not exist or is not readable", (Object)candidateClientCertFile);
            }
        }
        if (Systems.hasEnvVarOrSystemProperty((String)KUBERNETES_CLIENT_CERTIFICATE_DATA_ENV_VAR)) {
            this.clientCertData = Systems.getEnvVarOrSystemProperty((String)KUBERNETES_CLIENT_CERTIFICATE_DATA_ENV_VAR);
        }
        if (Systems.hasEnvVarOrSystemProperty((String)KUBERNETES_CLIENT_KEY_FILE_ENV_VAR)) {
            File candidateClientKeyFile = new File(Systems.getEnvVarOrSystemProperty((String)KUBERNETES_CLIENT_KEY_FILE_ENV_VAR));
            if (candidateClientKeyFile.exists() && candidateClientKeyFile.canRead()) {
                this.clientKeyFile = candidateClientKeyFile;
            } else {
                this.log.error("Specified client key file {} does not exist or is not readable", (Object)candidateClientKeyFile);
            }
        }
        if (Systems.hasEnvVarOrSystemProperty((String)KUBERNETES_CLIENT_KEY_DATA_ENV_VAR)) {
            this.clientKeyData = Systems.getEnvVarOrSystemProperty((String)KUBERNETES_CLIENT_KEY_DATA_ENV_VAR);
        }
        if (Systems.hasEnvVarOrSystemProperty((String)KUBERNETES_CLIENT_KEY_ALGO_ENV_VAR)) {
            this.clientKeyAlgo = Systems.getEnvVarOrSystemProperty((String)KUBERNETES_CLIENT_KEY_ALGO_ENV_VAR);
        }
        if (Systems.hasEnvVarOrSystemProperty((String)KUBERNETES_CLIENT_KEY_PASSWORD_ENV_VAR)) {
            this.clientKeyPassword = Systems.getEnvVarOrSystemProperty((String)KUBERNETES_CLIENT_KEY_PASSWORD_ENV_VAR).toCharArray();
        }
    }

    private void configureFromKubeConfig() {
        Context currentContext;
        Config kubeConfig = Configs.parseConfigs();
        if (kubeConfig != null && (currentContext = Configs.getCurrentContext(kubeConfig)) != null) {
            AuthInfo authInfo;
            Cluster currentCluster = Configs.getCluster(kubeConfig, currentContext);
            if (currentCluster.getServer() != null) {
                this.setAddress(currentCluster.getServer());
                if (currentCluster.getInsecureSkipTlsVerify() != null) {
                    this.trustAllCerts = currentCluster.getInsecureSkipTlsVerify();
                }
                if (currentCluster.getCertificateAuthority() != null) {
                    File candidateCaCertFile = new File(currentCluster.getCertificateAuthority());
                    if (candidateCaCertFile.exists() && candidateCaCertFile.canRead()) {
                        this.caCertFile = candidateCaCertFile;
                    } else {
                        this.log.error("Specified CA certificate file {} does not exist or is not readable", (Object)candidateCaCertFile);
                    }
                }
                if (currentCluster.getCertificateAuthorityData() != null) {
                    this.caCertData = currentCluster.getCertificateAuthorityData();
                }
            }
            if ((authInfo = Configs.getUserAuthInfo(kubeConfig, currentContext)) != null) {
                if (authInfo.getClientCertificate() != null) {
                    File candidateClientCertFile = new File(authInfo.getClientCertificate());
                    if (candidateClientCertFile.exists() && candidateClientCertFile.canRead()) {
                        this.clientCertFile = candidateClientCertFile;
                    } else {
                        this.log.error("Specified client certificate file {} does not exist or is not readable", (Object)candidateClientCertFile);
                    }
                }
                if (authInfo.getClientCertificateData() != null) {
                    this.clientCertData = authInfo.getClientCertificateData();
                }
                if (authInfo.getClientKey() != null) {
                    File candidateClientKeyFile = new File(authInfo.getClientKey());
                    if (candidateClientKeyFile.exists() && candidateClientKeyFile.canRead()) {
                        this.clientKeyFile = candidateClientKeyFile;
                    } else {
                        this.log.error("Specified client key file {} does not exist or is not readable", (Object)candidateClientKeyFile);
                    }
                }
                if (authInfo.getClientKeyData() != null) {
                    this.clientKeyData = authInfo.getClientKeyData();
                }
                if (authInfo.getUsername() != null) {
                    this.username = authInfo.getUsername();
                }
                if (authInfo.getPassword() != null) {
                    this.password = authInfo.getPassword();
                }
            }
        }
    }

    public String toString() {
        return "KubernetesFactory{" + this.address + '}';
    }

    public Kubernetes createKubernetes() {
        return this.createWebClient(Kubernetes.class);
    }

    public KubernetesExtensions createKubernetesExtensions() {
        return this.createWebClient(KubernetesExtensions.class);
    }

    public KubernetesGlobalExtensions createKubernetesGlobalExtensions() {
        return this.createWebClient(KubernetesGlobalExtensions.class);
    }

    public <T> T createWebClient(Class<T> clientType) {
        WebClient webClient = this.createWebClient();
        return (T)JAXRSClientFactory.fromClient((Client)webClient, clientType);
    }

    public WebClient createWebClient() {
        if (Strings.isNullOrBlank((String)this.address)) {
            this.init(this.address);
        }
        if (Strings.isNullOrBlank((String)this.address)) {
            throw new IllegalArgumentException("No kubernetes master address could be discovered using either the kubernetes config file ~/.kube/config or $KUBERNETES_SERVICE_HOST and $KUBERNETES_SERVICE_PORT enviroment variables");
        }
        return this.createWebClient(this.address);
    }

    public WebClient createWebClient(String serviceAddress) {
        List<Object> providers = this.createProviders();
        AuthorizationHeaderFilter authorizationHeaderFilter = new AuthorizationHeaderFilter();
        providers.add(authorizationHeaderFilter);
        try {
            String token;
            WebClient webClient = WebClient.create((String)serviceAddress, providers);
            WebClients.configureUserAndPassword((WebClient)webClient, (String)this.username, (String)this.password);
            boolean registeredCert = false;
            if (this.trustAllCerts) {
                WebClients.disableSslChecks((WebClient)webClient);
            } else if (this.caCertFile != null || this.caCertData != null) {
                WebClients.configureCaCert((WebClient)webClient, (String)this.caCertData, (File)this.caCertFile);
                if (this.disableHostNameChecks) {
                    WebClients.disableHostNameChecks((WebClient)webClient);
                }
            }
            if (!(this.clientCertFile == null && this.clientCertData == null || this.clientKeyFile == null && this.clientKeyData == null)) {
                WebClients.configureClientCert((WebClient)webClient, (String)this.clientCertData, (File)this.clientCertFile, (String)this.clientKeyData, (File)this.clientKeyFile, (String)this.clientKeyAlgo, (char[])this.clientKeyPassword);
                registeredCert = true;
            }
            if (!registeredCert && Strings.isNotBlank((String)(token = this.findToken()))) {
                String authHeader = "Bearer " + token;
                authorizationHeaderFilter.setAuthorizationHeader(authHeader);
            }
            return webClient;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed to create Kubernetes client at " + serviceAddress + ". " + e, e);
        }
    }

    public WebSocketClient createWebSocketClient() throws Exception {
        SslContextFactory sslContextFactory = null;
        if (this.trustAllCerts) {
            sslContextFactory = new SslContextFactory(this.trustAllCerts);
        } else if (this.caCertData != null || this.caCertFile != null) {
            KeyStore trustStore = WebClients.createTrustStore((String)this.caCertData, (File)this.caCertFile);
            sslContextFactory = new SslContextFactory();
            sslContextFactory.setTrustStore(trustStore);
        }
        if (!(this.clientCertFile == null && this.clientCertData == null || this.clientKeyFile == null && this.clientKeyData == null)) {
            if (sslContextFactory == null) {
                sslContextFactory = new SslContextFactory();
            }
            KeyStore keyStore = WebClients.createKeyStore((String)this.clientCertData, (File)this.clientCertFile, (String)this.clientKeyData, (File)this.clientKeyFile, (String)this.clientKeyAlgo, (char[])this.clientKeyPassword);
            sslContextFactory.setKeyStore(keyStore);
            sslContextFactory.setKeyStorePassword(new String(this.clientKeyPassword));
            sslContextFactory.setKeyManagerPassword(new String(this.clientKeyPassword));
        }
        sslContextFactory.setIncludeProtocols(new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"});
        WebSocketClient client = new WebSocketClient(sslContextFactory);
        return client;
    }

    public String findToken() {
        String token = this.getServiceAccountToken();
        if (Strings.isNotBlank((String)token)) {
            return token;
        }
        return this.findOpenShiftToken();
    }

    public String getServiceAccountToken() {
        try {
            return new String(Files.readAllBytes(Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/token", new String[0])));
        }
        catch (IOException e) {
            this.log.debug("Cannot read service account token");
            return null;
        }
    }

    public String findOpenShiftToken() {
        Context context;
        Config config = Configs.parseConfigs();
        if (config != null && (context = Configs.getCurrentContext(config)) != null) {
            return Configs.getUserToken(config, context);
        }
        return null;
    }

    protected List<Object> createProviders() {
        ArrayList<Object> providers = new ArrayList<Object>();
        Annotations[] annotationsToUse = JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS;
        ObjectMapper objectMapper = KubernetesFactory.createObjectMapper();
        providers.add(new JacksonJaxbJsonProvider(objectMapper, annotationsToUse));
        providers.add((Object)new PlainTextJacksonProvider(objectMapper, annotationsToUse));
        providers.add(new ExceptionResponseMapper());
        return providers;
    }

    public String getKubernetesMaster() {
        String answer = this.address;
        int idx = answer.lastIndexOf(":");
        if (idx > 0) {
            answer = answer.substring(0, idx);
        }
        if ((idx = answer.lastIndexOf(":")) > 0) {
            answer = answer.substring(idx + 1);
        }
        if ((idx = answer.lastIndexOf("/")) > 0) {
            answer = answer.substring(idx + 1);
        }
        return answer;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
        if (Strings.isNullOrBlank((String)address)) {
            this.address = this.findKubernetesMaster();
        }
        if (this.verifyAddress) {
            try {
                URL url = new URL(this.address);
                int port = url.getPort();
                this.address = port > 0 && KubernetesHelper.isServiceSsl(url.getHost(), port, true) ? "https://" + url.getHost() + ":" + port : "http://" + url.getHost() + (port > 0 && port != 80 ? ":" + port : "");
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid kubernetes master address", e);
            }
        }
    }

    public static String resolveHttpKubernetesMaster() {
        String kubernetesMaster = KubernetesFactory.resolveKubernetesMaster();
        if (kubernetesMaster != null && kubernetesMaster.startsWith("tcp:")) {
            return "https:" + kubernetesMaster.substring(4);
        }
        return kubernetesMaster;
    }

    public static String resolveKubernetesMaster() {
        String hostEnvVar = KUBERNETES_SERVICE_HOST_ENV_VAR;
        String portEnvVar = KUBERNETES_SERVICE_PORT_ENV_VAR;
        String proto = "https";
        String kubernetesMaster = System.getenv(hostEnvVar);
        kubernetesMaster = Strings.isNotBlank((String)kubernetesMaster) ? proto + "://" + kubernetesMaster + ":" + System.getenv(portEnvVar) : Systems.getSystemPropertyOrEnvVar((String)KUBERNETES_MASTER_SYSTEM_PROPERTY, (String)KUBERNETES_MASTER_ENV_VAR, null);
        return kubernetesMaster;
    }

    public static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        return mapper;
    }

    @Provider
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public static class PlainTextJacksonProvider
    extends JacksonJaxbJsonProvider {
        public PlainTextJacksonProvider(ObjectMapper mapper, Annotations[] annotationsToUse) {
            super(mapper, annotationsToUse);
        }

        protected boolean hasMatchingMediaType(MediaType mediaType) {
            boolean answer = super.hasMatchingMediaType(mediaType);
            String type = mediaType.getType();
            String subtype = mediaType.getSubtype();
            if (!answer && type.equals("text")) {
                answer = super.hasMatchingMediaType(MediaType.APPLICATION_JSON_TYPE);
            }
            return answer;
        }
    }
}

