/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.extensions;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.config.AuthInfo;
import io.fabric8.kubernetes.api.model.config.Config;
import io.fabric8.kubernetes.api.model.config.Context;
import io.fabric8.kubernetes.api.model.config.NamedAuthInfo;
import io.fabric8.kubernetes.api.model.config.NamedContext;
import io.fabric8.utils.Objects;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configs {
    public static final String OPENSHIFT_CONFIG_FILE_PROPERTY = "openshift.config.file";
    public static final String OPENSHIFT_CONFIG_FILE_ENV_VAR = "OPENSHIFTCONFIG";
    private static final transient Logger LOG = LoggerFactory.getLogger(Configs.class);

    public static Config parseConfigs() {
        File file = Configs.getOpenShiftConfigFile();
        if (file.exists() && file.isFile()) {
            try {
                return KubernetesHelper.loadYaml(file, Config.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Context getCurrentContext(Config config) {
        List contexts;
        String contextName = config.getCurrentContext();
        if (contextName != null && (contexts = config.getContexts()) != null) {
            for (NamedContext context : contexts) {
                if (!Objects.equal((Object)contextName, (Object)context.getName())) continue;
                return context.getContext();
            }
        }
        return null;
    }

    public static String getUserToken(Config config, Context context) {
        AuthInfo authInfo = Configs.getUserAuthInfo(config, context);
        if (authInfo != null) {
            return authInfo.getToken();
        }
        return null;
    }

    public static AuthInfo getUserAuthInfo(Config config, Context context) {
        List users;
        String user;
        AuthInfo authInfo = null;
        if (config != null && context != null && (user = context.getUser()) != null && (users = config.getUsers()) != null) {
            for (NamedAuthInfo namedAuthInfo : users) {
                if (!Objects.equal((Object)user, (Object)namedAuthInfo.getName())) continue;
                authInfo = namedAuthInfo.getUser();
            }
        }
        return authInfo;
    }

    public static File getOpenShiftConfigFile() {
        String file = System.getProperty(OPENSHIFT_CONFIG_FILE_PROPERTY);
        if (file != null) {
            return new File(file);
        }
        file = System.getenv(OPENSHIFT_CONFIG_FILE_ENV_VAR);
        if (file != null) {
            return new File(file);
        }
        String homeDir = System.getProperty("user.home", ".");
        return new File(homeDir, ".config/openshift/config");
    }
}

