/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.okhttp;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.okhttp.OkHttpClientBuilderImpl;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;

public class OkHttpClientFactory
implements HttpClient.Factory {
    @Override
    public int priority() {
        return -1;
    }

    protected OkHttpClient.Builder newOkHttpClientBuilder() {
        return new OkHttpClient.Builder().dispatcher(this.initDispatcher());
    }

    protected void additionalConfig(OkHttpClient.Builder builder) {
    }

    @Override
    public OkHttpClientBuilderImpl newBuilder() {
        return new OkHttpClientBuilderImpl(this, this.newOkHttpClientBuilder());
    }

    @Override
    public OkHttpClientBuilderImpl newBuilder(Config config) {
        try {
            OkHttpClientBuilderImpl builderWrapper = this.newBuilder();
            OkHttpClient.Builder httpClientBuilder = builderWrapper.getBuilder();
            httpClientBuilder.readTimeout(Duration.ZERO).writeTimeout(Duration.ZERO);
            if (config.isTrustCerts() || config.isDisableHostnameVerification()) {
                httpClientBuilder.hostnameVerifier((s, sslSession) -> true);
            }
            if (config.getWebsocketPingInterval() > 0L) {
                httpClientBuilder.pingInterval(config.getWebsocketPingInterval(), TimeUnit.MILLISECONDS);
            }
            HttpClientUtils.applyCommonConfiguration(config, builderWrapper, this);
            if (this.shouldDisableHttp2() && !config.isHttp2Disable()) {
                builderWrapper.preferHttp11();
            }
            return builderWrapper;
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    protected boolean shouldDisableHttp2() {
        return System.getProperty("java.version", "").startsWith("1.8");
    }

    protected Dispatcher initDispatcher() {
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(Integer.MAX_VALUE);
        dispatcher.setMaxRequestsPerHost(Integer.MAX_VALUE);
        return dispatcher;
    }
}

