/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.metrics.v1beta1.NodeMetrics;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NodeMetricsFluent<A extends NodeMetricsFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private String timestamp;
    private Map<String, Quantity> usage;
    private Duration window;
    private Map<String, Object> additionalProperties;

    public NodeMetricsFluent() {
    }

    public NodeMetricsFluent(NodeMetrics instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NodeMetrics instance) {
        NodeMetrics nodeMetrics = instance = instance != null ? instance : new NodeMetrics();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withTimestamp(instance.getTimestamp());
            this.withUsage(instance.getUsage());
            this.withWindow(instance.getWindow());
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withTimestamp(instance.getTimestamp());
            this.withUsage(instance.getUsage());
            this.withWindow(instance.getWindow());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public A withTimestamp(String timestamp) {
        this.timestamp = timestamp;
        return (A)this;
    }

    public boolean hasTimestamp() {
        return this.timestamp != null;
    }

    public A addToUsage(String key, Quantity value) {
        if (this.usage == null && key != null && value != null) {
            this.usage = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.usage.put(key, value);
        }
        return (A)this;
    }

    public A addToUsage(Map<String, Quantity> map) {
        if (this.usage == null && map != null) {
            this.usage = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.usage.putAll(map);
        }
        return (A)this;
    }

    public A removeFromUsage(String key) {
        if (this.usage == null) {
            return (A)this;
        }
        if (key != null && this.usage != null) {
            this.usage.remove(key);
        }
        return (A)this;
    }

    public A removeFromUsage(Map<String, Quantity> map) {
        if (this.usage == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.usage == null) continue;
                this.usage.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Quantity> getUsage() {
        return this.usage;
    }

    public <K, V> A withUsage(Map<String, Quantity> usage) {
        this.usage = usage == null ? null : new LinkedHashMap<String, Quantity>(usage);
        return (A)this;
    }

    public boolean hasUsage() {
        return this.usage != null;
    }

    public Duration getWindow() {
        return this.window;
    }

    public A withWindow(Duration window) {
        this.window = window;
        return (A)this;
    }

    public boolean hasWindow() {
        return this.window != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeMetricsFluent that = (NodeMetricsFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.timestamp, that.timestamp)) {
            return false;
        }
        if (!Objects.equals(this.usage, that.usage)) {
            return false;
        }
        if (!Objects.equals(this.window, that.window)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.timestamp, this.usage, this.window, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.timestamp != null) {
            sb.append("timestamp:");
            sb.append(this.timestamp + ",");
        }
        if (this.usage != null && !this.usage.isEmpty()) {
            sb.append("usage:");
            sb.append(this.usage + ",");
        }
        if (this.window != null) {
            sb.append("window:");
            sb.append(this.window + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NodeMetricsFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

