/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.events.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.MicroTime;
import io.fabric8.kubernetes.api.model.events.v1beta1.EventSeries;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class EventSeriesFluent<A extends EventSeriesFluent<A>>
extends BaseFluent<A> {
    private Integer count;
    private MicroTime lastObservedTime;
    private Map<String, Object> additionalProperties;

    public EventSeriesFluent() {
    }

    public EventSeriesFluent(EventSeries instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(EventSeries instance) {
        EventSeries eventSeries = instance = instance != null ? instance : new EventSeries();
        if (instance != null) {
            this.withCount(instance.getCount());
            this.withLastObservedTime(instance.getLastObservedTime());
            this.withCount(instance.getCount());
            this.withLastObservedTime(instance.getLastObservedTime());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getCount() {
        return this.count;
    }

    public A withCount(Integer count) {
        this.count = count;
        return (A)this;
    }

    public boolean hasCount() {
        return this.count != null;
    }

    public MicroTime getLastObservedTime() {
        return this.lastObservedTime;
    }

    public A withLastObservedTime(MicroTime lastObservedTime) {
        this.lastObservedTime = lastObservedTime;
        return (A)this;
    }

    public boolean hasLastObservedTime() {
        return this.lastObservedTime != null;
    }

    public A withNewLastObservedTime(String time) {
        return this.withLastObservedTime(new MicroTime(time));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventSeriesFluent that = (EventSeriesFluent)o;
        if (!Objects.equals(this.count, that.count)) {
            return false;
        }
        if (!Objects.equals(this.lastObservedTime, that.lastObservedTime)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.count, this.lastObservedTime, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.count != null) {
            sb.append("count:");
            sb.append(this.count + ",");
        }
        if (this.lastObservedTime != null) {
            sb.append("lastObservedTime:");
            sb.append(this.lastObservedTime + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

