/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.EndpointSubsetBuilder;
import io.fabric8.kubernetes.api.model.EndpointSubsetFluent;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class EndpointsFluent<A extends EndpointsFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ArrayList<EndpointSubsetBuilder> subsets = new ArrayList();
    private Map<String, Object> additionalProperties;

    public EndpointsFluent() {
    }

    public EndpointsFluent(Endpoints instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Endpoints instance) {
        Endpoints endpoints = instance = instance != null ? instance : new Endpoints();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSubsets(instance.getSubsets());
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSubsets(instance.getSubsets());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public A addToSubsets(int index, EndpointSubset item) {
        if (this.subsets == null) {
            this.subsets = new ArrayList();
        }
        EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);
        if (index < 0 || index >= this.subsets.size()) {
            this._visitables.get("subsets").add(builder);
            this.subsets.add(builder);
        } else {
            this._visitables.get("subsets").add(index, builder);
            this.subsets.add(index, builder);
        }
        return (A)this;
    }

    public A setToSubsets(int index, EndpointSubset item) {
        if (this.subsets == null) {
            this.subsets = new ArrayList();
        }
        EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);
        if (index < 0 || index >= this.subsets.size()) {
            this._visitables.get("subsets").add(builder);
            this.subsets.add(builder);
        } else {
            this._visitables.get("subsets").set(index, builder);
            this.subsets.set(index, builder);
        }
        return (A)this;
    }

    public A addToSubsets(EndpointSubset ... items) {
        if (this.subsets == null) {
            this.subsets = new ArrayList();
        }
        for (EndpointSubset item : items) {
            EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);
            this._visitables.get("subsets").add(builder);
            this.subsets.add(builder);
        }
        return (A)this;
    }

    public A addAllToSubsets(Collection<EndpointSubset> items) {
        if (this.subsets == null) {
            this.subsets = new ArrayList();
        }
        for (EndpointSubset item : items) {
            EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);
            this._visitables.get("subsets").add(builder);
            this.subsets.add(builder);
        }
        return (A)this;
    }

    public A removeFromSubsets(EndpointSubset ... items) {
        if (this.subsets == null) {
            return (A)this;
        }
        for (EndpointSubset item : items) {
            EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);
            this._visitables.get("subsets").remove(builder);
            this.subsets.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSubsets(Collection<EndpointSubset> items) {
        if (this.subsets == null) {
            return (A)this;
        }
        for (EndpointSubset item : items) {
            EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);
            this._visitables.get("subsets").remove(builder);
            this.subsets.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSubsets(Predicate<EndpointSubsetBuilder> predicate) {
        if (this.subsets == null) {
            return (A)this;
        }
        Iterator<EndpointSubsetBuilder> each = this.subsets.iterator();
        Object visitables = this._visitables.get("subsets");
        while (each.hasNext()) {
            EndpointSubsetBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<EndpointSubset> buildSubsets() {
        return this.subsets != null ? EndpointsFluent.build(this.subsets) : null;
    }

    public EndpointSubset buildSubset(int index) {
        return this.subsets.get(index).build();
    }

    public EndpointSubset buildFirstSubset() {
        return this.subsets.get(0).build();
    }

    public EndpointSubset buildLastSubset() {
        return this.subsets.get(this.subsets.size() - 1).build();
    }

    public EndpointSubset buildMatchingSubset(Predicate<EndpointSubsetBuilder> predicate) {
        for (EndpointSubsetBuilder item : this.subsets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSubset(Predicate<EndpointSubsetBuilder> predicate) {
        for (EndpointSubsetBuilder item : this.subsets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSubsets(List<EndpointSubset> subsets) {
        if (this.subsets != null) {
            this._visitables.get("subsets").clear();
        }
        if (subsets != null) {
            this.subsets = new ArrayList();
            for (EndpointSubset item : subsets) {
                this.addToSubsets(item);
            }
        } else {
            this.subsets = null;
        }
        return (A)this;
    }

    public A withSubsets(EndpointSubset ... subsets) {
        if (this.subsets != null) {
            this.subsets.clear();
            this._visitables.remove("subsets");
        }
        if (subsets != null) {
            for (EndpointSubset item : subsets) {
                this.addToSubsets(item);
            }
        }
        return (A)this;
    }

    public boolean hasSubsets() {
        return this.subsets != null && !this.subsets.isEmpty();
    }

    public SubsetsNested<A> addNewSubset() {
        return new SubsetsNested(-1, null);
    }

    public SubsetsNested<A> addNewSubsetLike(EndpointSubset item) {
        return new SubsetsNested(-1, item);
    }

    public SubsetsNested<A> setNewSubsetLike(int index, EndpointSubset item) {
        return new SubsetsNested(index, item);
    }

    public SubsetsNested<A> editSubset(int index) {
        if (this.subsets.size() <= index) {
            throw new RuntimeException("Can't edit subsets. Index exceeds size.");
        }
        return this.setNewSubsetLike(index, this.buildSubset(index));
    }

    public SubsetsNested<A> editFirstSubset() {
        if (this.subsets.size() == 0) {
            throw new RuntimeException("Can't edit first subsets. The list is empty.");
        }
        return this.setNewSubsetLike(0, this.buildSubset(0));
    }

    public SubsetsNested<A> editLastSubset() {
        int index = this.subsets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subsets. The list is empty.");
        }
        return this.setNewSubsetLike(index, this.buildSubset(index));
    }

    public SubsetsNested<A> editMatchingSubset(Predicate<EndpointSubsetBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subsets.size(); ++i) {
            if (!predicate.test(this.subsets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subsets. No match found.");
        }
        return this.setNewSubsetLike(index, this.buildSubset(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointsFluent that = (EndpointsFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.subsets, that.subsets)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.subsets, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.subsets != null && !this.subsets.isEmpty()) {
            sb.append("subsets:");
            sb.append(this.subsets + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SubsetsNested<N>
    extends EndpointSubsetFluent<SubsetsNested<N>>
    implements Nested<N> {
        EndpointSubsetBuilder builder;
        int index;

        SubsetsNested(int index, EndpointSubset item) {
            this.index = index;
            this.builder = new EndpointSubsetBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EndpointsFluent.this.setToSubsets(this.index, this.builder.build());
        }

        public N endSubset() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EndpointsFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

