/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.NodeSelector;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.ResourceClass;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.ResourceClassParametersReference;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.ResourceClassParametersReferenceBuilder;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.ResourceClassParametersReferenceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ResourceClassFluent<A extends ResourceClassFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String driverName;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ResourceClassParametersReferenceBuilder parametersRef;
    private NodeSelector suitableNodes;
    private Map<String, Object> additionalProperties;

    public ResourceClassFluent() {
    }

    public ResourceClassFluent(ResourceClass instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ResourceClass instance) {
        ResourceClass resourceClass = instance = instance != null ? instance : new ResourceClass();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withDriverName(instance.getDriverName());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withParametersRef(instance.getParametersRef());
            this.withSuitableNodes(instance.getSuitableNodes());
            this.withApiVersion(instance.getApiVersion());
            this.withDriverName(instance.getDriverName());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withParametersRef(instance.getParametersRef());
            this.withSuitableNodes(instance.getSuitableNodes());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public A withDriverName(String driverName) {
        this.driverName = driverName;
        return (A)this;
    }

    public boolean hasDriverName() {
        return this.driverName != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public ResourceClassParametersReference buildParametersRef() {
        return this.parametersRef != null ? this.parametersRef.build() : null;
    }

    public A withParametersRef(ResourceClassParametersReference parametersRef) {
        this._visitables.get("parametersRef").remove(this.parametersRef);
        if (parametersRef != null) {
            this.parametersRef = new ResourceClassParametersReferenceBuilder(parametersRef);
            this._visitables.get("parametersRef").add(this.parametersRef);
        } else {
            this.parametersRef = null;
            this._visitables.get("parametersRef").remove(this.parametersRef);
        }
        return (A)this;
    }

    public boolean hasParametersRef() {
        return this.parametersRef != null;
    }

    public A withNewParametersRef(String apiGroup, String kind, String name, String namespace) {
        return this.withParametersRef(new ResourceClassParametersReference(apiGroup, kind, name, namespace));
    }

    public ParametersRefNested<A> withNewParametersRef() {
        return new ParametersRefNested(null);
    }

    public ParametersRefNested<A> withNewParametersRefLike(ResourceClassParametersReference item) {
        return new ParametersRefNested(item);
    }

    public ParametersRefNested<A> editParametersRef() {
        return this.withNewParametersRefLike(Optional.ofNullable(this.buildParametersRef()).orElse(null));
    }

    public ParametersRefNested<A> editOrNewParametersRef() {
        return this.withNewParametersRefLike(Optional.ofNullable(this.buildParametersRef()).orElse(new ResourceClassParametersReferenceBuilder().build()));
    }

    public ParametersRefNested<A> editOrNewParametersRefLike(ResourceClassParametersReference item) {
        return this.withNewParametersRefLike(Optional.ofNullable(this.buildParametersRef()).orElse(item));
    }

    public NodeSelector getSuitableNodes() {
        return this.suitableNodes;
    }

    public A withSuitableNodes(NodeSelector suitableNodes) {
        this.suitableNodes = suitableNodes;
        return (A)this;
    }

    public boolean hasSuitableNodes() {
        return this.suitableNodes != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceClassFluent that = (ResourceClassFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.driverName, that.driverName)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.parametersRef, that.parametersRef)) {
            return false;
        }
        if (!Objects.equals(this.suitableNodes, that.suitableNodes)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.driverName, this.kind, this.metadata, this.parametersRef, this.suitableNodes, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.driverName != null) {
            sb.append("driverName:");
            sb.append(this.driverName + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.parametersRef != null) {
            sb.append("parametersRef:");
            sb.append(this.parametersRef + ",");
        }
        if (this.suitableNodes != null) {
            sb.append("suitableNodes:");
            sb.append(this.suitableNodes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ParametersRefNested<N>
    extends ResourceClassParametersReferenceFluent<ParametersRefNested<N>>
    implements Nested<N> {
        ResourceClassParametersReferenceBuilder builder;

        ParametersRefNested(ResourceClassParametersReference item) {
            this.builder = new ResourceClassParametersReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ResourceClassFluent.this.withParametersRef(this.builder.build());
        }

        public N endParametersRef() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ResourceClassFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

