/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.autoscaling.v2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.autoscaling.v2.CrossVersionObjectReference;
import io.fabric8.kubernetes.api.model.autoscaling.v2.CrossVersionObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v2.CrossVersionObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.autoscaling.v2.MetricIdentifier;
import io.fabric8.kubernetes.api.model.autoscaling.v2.MetricIdentifierBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v2.MetricIdentifierFluent;
import io.fabric8.kubernetes.api.model.autoscaling.v2.MetricTarget;
import io.fabric8.kubernetes.api.model.autoscaling.v2.MetricTargetBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v2.MetricTargetFluent;
import io.fabric8.kubernetes.api.model.autoscaling.v2.ObjectMetricSource;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ObjectMetricSourceFluent<A extends ObjectMetricSourceFluent<A>>
extends BaseFluent<A> {
    private CrossVersionObjectReferenceBuilder describedObject;
    private MetricIdentifierBuilder metric;
    private MetricTargetBuilder target;
    private Map<String, Object> additionalProperties;

    public ObjectMetricSourceFluent() {
    }

    public ObjectMetricSourceFluent(ObjectMetricSource instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ObjectMetricSource instance) {
        ObjectMetricSource objectMetricSource = instance = instance != null ? instance : new ObjectMetricSource();
        if (instance != null) {
            this.withDescribedObject(instance.getDescribedObject());
            this.withMetric(instance.getMetric());
            this.withTarget(instance.getTarget());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public CrossVersionObjectReference buildDescribedObject() {
        return this.describedObject != null ? this.describedObject.build() : null;
    }

    public A withDescribedObject(CrossVersionObjectReference describedObject) {
        this._visitables.remove("describedObject");
        if (describedObject != null) {
            this.describedObject = new CrossVersionObjectReferenceBuilder(describedObject);
            this._visitables.get("describedObject").add(this.describedObject);
        } else {
            this.describedObject = null;
            this._visitables.get("describedObject").remove(this.describedObject);
        }
        return (A)this;
    }

    public boolean hasDescribedObject() {
        return this.describedObject != null;
    }

    public A withNewDescribedObject(String apiVersion, String kind, String name) {
        return this.withDescribedObject(new CrossVersionObjectReference(apiVersion, kind, name));
    }

    public DescribedObjectNested<A> withNewDescribedObject() {
        return new DescribedObjectNested(null);
    }

    public DescribedObjectNested<A> withNewDescribedObjectLike(CrossVersionObjectReference item) {
        return new DescribedObjectNested(item);
    }

    public DescribedObjectNested<A> editDescribedObject() {
        return this.withNewDescribedObjectLike(Optional.ofNullable(this.buildDescribedObject()).orElse(null));
    }

    public DescribedObjectNested<A> editOrNewDescribedObject() {
        return this.withNewDescribedObjectLike(Optional.ofNullable(this.buildDescribedObject()).orElse(new CrossVersionObjectReferenceBuilder().build()));
    }

    public DescribedObjectNested<A> editOrNewDescribedObjectLike(CrossVersionObjectReference item) {
        return this.withNewDescribedObjectLike(Optional.ofNullable(this.buildDescribedObject()).orElse(item));
    }

    public MetricIdentifier buildMetric() {
        return this.metric != null ? this.metric.build() : null;
    }

    public A withMetric(MetricIdentifier metric) {
        this._visitables.remove("metric");
        if (metric != null) {
            this.metric = new MetricIdentifierBuilder(metric);
            this._visitables.get("metric").add(this.metric);
        } else {
            this.metric = null;
            this._visitables.get("metric").remove(this.metric);
        }
        return (A)this;
    }

    public boolean hasMetric() {
        return this.metric != null;
    }

    public MetricNested<A> withNewMetric() {
        return new MetricNested(null);
    }

    public MetricNested<A> withNewMetricLike(MetricIdentifier item) {
        return new MetricNested(item);
    }

    public MetricNested<A> editMetric() {
        return this.withNewMetricLike(Optional.ofNullable(this.buildMetric()).orElse(null));
    }

    public MetricNested<A> editOrNewMetric() {
        return this.withNewMetricLike(Optional.ofNullable(this.buildMetric()).orElse(new MetricIdentifierBuilder().build()));
    }

    public MetricNested<A> editOrNewMetricLike(MetricIdentifier item) {
        return this.withNewMetricLike(Optional.ofNullable(this.buildMetric()).orElse(item));
    }

    public MetricTarget buildTarget() {
        return this.target != null ? this.target.build() : null;
    }

    public A withTarget(MetricTarget target) {
        this._visitables.remove("target");
        if (target != null) {
            this.target = new MetricTargetBuilder(target);
            this._visitables.get("target").add(this.target);
        } else {
            this.target = null;
            this._visitables.get("target").remove(this.target);
        }
        return (A)this;
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    public TargetNested<A> withNewTarget() {
        return new TargetNested(null);
    }

    public TargetNested<A> withNewTargetLike(MetricTarget item) {
        return new TargetNested(item);
    }

    public TargetNested<A> editTarget() {
        return this.withNewTargetLike(Optional.ofNullable(this.buildTarget()).orElse(null));
    }

    public TargetNested<A> editOrNewTarget() {
        return this.withNewTargetLike(Optional.ofNullable(this.buildTarget()).orElse(new MetricTargetBuilder().build()));
    }

    public TargetNested<A> editOrNewTargetLike(MetricTarget item) {
        return this.withNewTargetLike(Optional.ofNullable(this.buildTarget()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectMetricSourceFluent that = (ObjectMetricSourceFluent)o;
        if (!Objects.equals(this.describedObject, that.describedObject)) {
            return false;
        }
        if (!Objects.equals(this.metric, that.metric)) {
            return false;
        }
        if (!Objects.equals(this.target, that.target)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.describedObject, this.metric, this.target, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.describedObject != null) {
            sb.append("describedObject:");
            sb.append(this.describedObject + ",");
        }
        if (this.metric != null) {
            sb.append("metric:");
            sb.append(this.metric + ",");
        }
        if (this.target != null) {
            sb.append("target:");
            sb.append(this.target + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TargetNested<N>
    extends MetricTargetFluent<TargetNested<N>>
    implements Nested<N> {
        MetricTargetBuilder builder;

        TargetNested(MetricTarget item) {
            this.builder = new MetricTargetBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ObjectMetricSourceFluent.this.withTarget(this.builder.build());
        }

        public N endTarget() {
            return this.and();
        }
    }

    public class MetricNested<N>
    extends MetricIdentifierFluent<MetricNested<N>>
    implements Nested<N> {
        MetricIdentifierBuilder builder;

        MetricNested(MetricIdentifier item) {
            this.builder = new MetricIdentifierBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ObjectMetricSourceFluent.this.withMetric(this.builder.build());
        }

        public N endMetric() {
            return this.and();
        }
    }

    public class DescribedObjectNested<N>
    extends CrossVersionObjectReferenceFluent<DescribedObjectNested<N>>
    implements Nested<N> {
        CrossVersionObjectReferenceBuilder builder;

        DescribedObjectNested(CrossVersionObjectReference item) {
            this.builder = new CrossVersionObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ObjectMetricSourceFluent.this.withDescribedObject(this.builder.build());
        }

        public N endDescribedObject() {
            return this.and();
        }
    }
}

