/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.extension;

import io.fabric8.kubernetes.api.model.APIGroup;
import io.fabric8.kubernetes.api.model.APIGroupList;
import io.fabric8.kubernetes.api.model.APIResourceList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.RequestConfig;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.http.HttpClient;
import java.net.URL;

public abstract class ClientAdapter<C extends ClientAdapter<C>>
implements Client {
    private Client client;

    public Client getClient() {
        return this.client;
    }

    public void init(Client client) {
        this.client = client;
    }

    @Override
    public HttpClient getHttpClient() {
        return this.client.getHttpClient();
    }

    @Override
    public Config getConfiguration() {
        return this.client.getConfiguration();
    }

    public <A extends Client> Boolean isAdaptable(Class<A> type) {
        return this.client.isAdaptable(type);
    }

    public <T extends KubernetesResource> boolean supports(Class<T> type) {
        return this.client.supports(type);
    }

    @Override
    public boolean supports(String apiVersion, String kind) {
        return this.client.supports(apiVersion, kind);
    }

    @Override
    public boolean hasApiGroup(String apiGroup, boolean exact) {
        return this.client.hasApiGroup(apiGroup, exact);
    }

    public <A extends Client> A adapt(Class<A> type) {
        return this.client.adapt(type);
    }

    @Override
    public URL getMasterUrl() {
        return this.client.getMasterUrl();
    }

    @Override
    public String getApiVersion() {
        return this.client.getApiVersion();
    }

    @Override
    public String getNamespace() {
        return this.client.getNamespace();
    }

    @Override
    public RootPaths rootPaths() {
        return this.client.rootPaths();
    }

    @Override
    public boolean supportsApiPath(String path) {
        return this.client.supportsApiPath(path);
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public APIGroupList getApiGroups() {
        return this.client.getApiGroups();
    }

    @Override
    public APIGroup getApiGroup(String name) {
        return this.client.getApiGroup(name);
    }

    @Override
    public APIResourceList getApiResources(String groupVersion) {
        return this.client.getApiResources(groupVersion);
    }

    @Override
    public <T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>> MixedOperation<T, L, R> resources(Class<T> resourceType, Class<L> listClass, Class<R> resourceClass) {
        return this.client.resources(resourceType, listClass, resourceClass);
    }

    public C inAnyNamespace() {
        C result = this.newInstance();
        ((ClientAdapter)result).init(this.client.adapt(NamespacedKubernetesClient.class).inAnyNamespace());
        return result;
    }

    public C inNamespace(String namespace) {
        C result = this.newInstance();
        ((ClientAdapter)result).init(this.client.adapt(NamespacedKubernetesClient.class).inNamespace(namespace));
        return result;
    }

    @Override
    public Client newClient(RequestConfig requestConfig) {
        return this.client.newClient(requestConfig);
    }

    public abstract C newInstance();

    @Override
    public String raw(String uri, String method, Object payload) {
        return this.client.raw(uri, method, payload);
    }
}

