/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.devops;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.fabric8.devops.ProjectConfig;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectConfigs {
    private static final transient Logger LOG = LoggerFactory.getLogger(ProjectConfigs.class);
    public static final String FILE_NAME = "fabric8.yml";

    public static String toYaml(Object dto) throws JsonProcessingException {
        ObjectMapper mapper = ProjectConfigs.createObjectMapper();
        return mapper.writeValueAsString(dto);
    }

    public static ObjectMapper createObjectMapper() {
        return new ObjectMapper((JsonFactory)new YAMLFactory());
    }

    public static ProjectConfig parseProjectConfig(File file) throws IOException {
        return ProjectConfigs.parseYaml(file, ProjectConfig.class);
    }

    private static <T> T parseYaml(File file, Class<T> clazz) throws IOException {
        ObjectMapper mapper = ProjectConfigs.createObjectMapper();
        return (T)mapper.readValue(file, clazz);
    }

    public static boolean saveToFolder(File basedir, ProjectConfig config, boolean overwriteIfExists) throws IOException {
        File file = new File(basedir, FILE_NAME);
        if (file.exists() && !overwriteIfExists) {
            LOG.warn("Not generating " + file + " as it already exists");
            return false;
        }
        ProjectConfigs.createObjectMapper().writeValue(file, (Object)config);
        return true;
    }
}

