/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jboss.jandex.AnnotationInstanceBuilder;
import org.jboss.jandex.AnnotationInstanceEquivalenceProxy;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ImmutableArrayList;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public final class AnnotationInstance {
    static final NameComparator NAME_COMPARATOR = new NameComparator();
    static final AnnotationInstance[] EMPTY_ARRAY = new AnnotationInstance[0];
    private final DotName name;
    private final AnnotationTarget target;
    private final AnnotationValue[] values;
    private final boolean runtimeVisible;

    private AnnotationInstance(DotName name, AnnotationTarget target, AnnotationValue[] values, boolean runtimeVisible) {
        this.name = name;
        this.target = target;
        this.values = values != null && values.length > 0 ? values : AnnotationValue.EMPTY_ARRAY;
        this.runtimeVisible = runtimeVisible;
    }

    static AnnotationInstance create(AnnotationInstance instance, AnnotationTarget target) {
        return new AnnotationInstance(instance.name, target, instance.values, instance.runtimeVisible);
    }

    public static AnnotationInstanceBuilder builder(Class<? extends Annotation> annotationType) {
        if (annotationType == null) {
            throw new IllegalArgumentException("Annotation type can't be null");
        }
        DotName name = DotName.createSimple(annotationType.getName());
        boolean visible = annotationType.isAnnotationPresent(Retention.class) && annotationType.getAnnotation(Retention.class).value() == RetentionPolicy.RUNTIME;
        return new AnnotationInstanceBuilder(name, visible);
    }

    public static AnnotationInstanceBuilder builder(ClassInfo annotationType) {
        if (annotationType == null) {
            throw new IllegalArgumentException("Annotation type can't be null");
        }
        DotName name = annotationType.name();
        boolean visible = annotationType.hasDeclaredAnnotation(DotName.RETENTION_NAME) && annotationType.declaredAnnotation(DotName.RETENTION_NAME).value().asString().equals("RUNTIME");
        return new AnnotationInstanceBuilder(name, visible);
    }

    public static AnnotationInstanceBuilder builder(DotName annotationType) {
        return AnnotationInstance.builder(annotationType, true);
    }

    public static AnnotationInstanceBuilder builder(DotName annotationType, boolean runtimeVisible) {
        if (annotationType == null) {
            throw new IllegalArgumentException("Annotation type can't be null");
        }
        return new AnnotationInstanceBuilder(annotationType, runtimeVisible);
    }

    public static AnnotationInstance create(DotName name, AnnotationTarget target, AnnotationValue[] values) {
        return AnnotationInstance.create(name, true, target, values);
    }

    public static AnnotationInstance create(DotName name, boolean visible, AnnotationTarget target, AnnotationValue[] values) {
        if (name == null) {
            throw new IllegalArgumentException("Name can't be null");
        }
        if (values == null) {
            throw new IllegalArgumentException("Values can't be null");
        }
        values = (AnnotationValue[])values.clone();
        Arrays.sort(values, new Comparator<AnnotationValue>(){

            @Override
            public int compare(AnnotationValue o1, AnnotationValue o2) {
                return o1.name().compareTo(o2.name());
            }
        });
        return new AnnotationInstance(name, target, values, visible);
    }

    public static AnnotationInstance create(DotName name, AnnotationTarget target, List<AnnotationValue> values) {
        return AnnotationInstance.create(name, true, target, values);
    }

    public static AnnotationInstance create(DotName name, boolean visible, AnnotationTarget target, List<AnnotationValue> values) {
        if (name == null) {
            throw new IllegalArgumentException("Name can't be null");
        }
        if (values == null) {
            throw new IllegalArgumentException("Values can't be null");
        }
        return AnnotationInstance.create(name, visible, target, values.toArray(AnnotationValue.EMPTY_ARRAY));
    }

    static AnnotationInstance binarySearch(AnnotationInstance[] annotations, DotName name) {
        AnnotationInstance key = new AnnotationInstance(name, null, null, false);
        int i = Arrays.binarySearch(annotations, key, NAME_COMPARATOR);
        return i >= 0 ? annotations[i] : null;
    }

    public DotName name() {
        return this.name;
    }

    public AnnotationTarget target() {
        return this.target;
    }

    public AnnotationValue value(final String name) {
        int result = Arrays.binarySearch(this.values, name, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return ((AnnotationValue)o1).name().compareTo(name);
            }
        });
        return result >= 0 ? this.values[result] : null;
    }

    public AnnotationValue value() {
        return this.value("value");
    }

    public AnnotationValue valueWithDefault(IndexView index, String name) {
        ClassInfo definition = index.getClassByName(this.name);
        if (definition == null) {
            throw new IllegalArgumentException("Index did not contain annotation definition: " + this.name);
        }
        AnnotationValue result = this.value(name);
        if (result != null) {
            return result;
        }
        MethodInfo method = definition.method(name, new Type[0]);
        return method == null ? null : method.defaultValue();
    }

    public AnnotationValue valueWithDefault(IndexView index) {
        return this.valueWithDefault(index, "value");
    }

    public List<AnnotationValue> valuesWithDefaults(IndexView index) {
        ClassInfo definition = index.getClassByName(this.name);
        if (definition == null) {
            throw new IllegalArgumentException("Index did not contain annotation definition: " + this.name);
        }
        List<MethodInfo> methods = definition.methods();
        ArrayList<AnnotationValue> result = new ArrayList<AnnotationValue>(methods.size());
        for (MethodInfo method : methods) {
            AnnotationValue value = this.value(method.name());
            if (value == null) {
                value = method.defaultValue();
            }
            if (value == null) continue;
            result.add(value);
        }
        return Collections.unmodifiableList(result);
    }

    public List<AnnotationValue> values() {
        return new ImmutableArrayList<AnnotationValue>(this.values);
    }

    AnnotationValue[] valueArray() {
        return this.values;
    }

    public boolean runtimeVisible() {
        return this.runtimeVisible;
    }

    public String toString(boolean simple) {
        StringBuilder builder = new StringBuilder("@").append(simple ? this.name.local() : this.name);
        if (simple && this.values.length == 1 && this.values[0].name().equals("value")) {
            builder.append("(");
            builder.append(this.values[0].toString(false));
            builder.append(')');
        } else if (this.values.length > 0) {
            builder.append("(");
            for (int i = 0; i < this.values.length; ++i) {
                builder.append(this.values[i]);
                if (i >= this.values.length - 1) continue;
                builder.append(",");
            }
            builder.append(')');
        }
        return builder.toString();
    }

    public String toString() {
        return this.toString(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationInstance instance = (AnnotationInstance)o;
        return this.target == instance.target && this.name.equals(instance.name) && Arrays.equals(this.values, instance.values);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + Arrays.hashCode(this.values);
        if (this.target != null) {
            switch (this.target.kind()) {
                case CLASS: {
                    result = 31 * result + this.target.asClass().name().hashCode();
                    break;
                }
                case METHOD: {
                    result = 31 * result + this.target.asMethod().declaringClass().name().hashCode();
                    result = 31 * result + Arrays.hashCode(this.target.asMethod().methodInternal().nameBytes());
                    break;
                }
                case FIELD: {
                    result = 31 * result + this.target.asField().declaringClass().name().hashCode();
                    result = 31 * result + Arrays.hashCode(this.target.asField().fieldInternal().nameBytes());
                    break;
                }
                case METHOD_PARAMETER: {
                    result = 31 * result + this.target.asMethodParameter().method().declaringClass().name().hashCode();
                    result = 31 * result + Arrays.hashCode(this.target.asMethodParameter().method().methodInternal().nameBytes());
                    result = 31 * result + this.target.asMethodParameter().position();
                    break;
                }
                case RECORD_COMPONENT: {
                    result = 31 * result + this.target.asRecordComponent().declaringClass().name().hashCode();
                    result = 31 * result + Arrays.hashCode(this.target.asRecordComponent().recordComponentInternal().nameBytes());
                    break;
                }
                case TYPE: {
                    if (this.target.asType().target() == null) break;
                    result = 31 * result + this.target.asType().target().name().hashCode();
                }
            }
        }
        return result;
    }

    public boolean equivalentTo(AnnotationInstance other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.name.equals(other.name) && Arrays.equals(this.values, other.values);
    }

    public int equivalenceHashCode() {
        int result = this.name.hashCode();
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    public AnnotationInstanceEquivalenceProxy createEquivalenceProxy() {
        return new AnnotationInstanceEquivalenceProxy(this);
    }

    static class NameComparator
    implements Comparator<AnnotationInstance> {
        NameComparator() {
        }

        @Override
        public int compare(AnnotationInstance instance1, AnnotationInstance instance2) {
            return instance1.name().compareTo(instance2.name());
        }
    }
}

