/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.ListOptionsBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public interface Watchable<T> {
    public Watch watch(Watcher<T> var1);

    public Watch watch(ListOptions var1, Watcher<T> var2);

    @Deprecated
    public Watch watch(String var1, Watcher<T> var2);

    default public CompletableFuture<String> streamingList(final Consumer<T> onItem) {
        final CompletableFuture<String> future = new CompletableFuture<String>();
        Watch watch = this.watch(((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withSendInitialEvents(true)).withResourceVersionMatch("NotOlderThan")).withAllowWatchBookmarks(true)).build(), new Watcher<T>(){

            @Override
            public void eventReceived(Watcher.Action action, T resource) {
                switch (action) {
                    case ADDED: {
                        onItem.accept(resource);
                        break;
                    }
                    case BOOKMARK: {
                        if (resource instanceof HasMetadata) {
                            future.complete(Optional.ofNullable(((HasMetadata)resource).getMetadata()).map(ObjectMeta::getResourceVersion).orElse(null));
                            break;
                        }
                        future.complete(null);
                        break;
                    }
                    default: {
                        if (action == Watcher.Action.ERROR && resource instanceof Status) {
                            Status status = (Status)resource;
                            future.completeExceptionally(new KubernetesClientException(status));
                            break;
                        }
                        future.completeExceptionally(new KubernetesClientException("Unexpected event before list ending bookmark: " + String.valueOf((Object)action)));
                    }
                }
            }

            @Override
            public void onClose(WatcherException cause) {
                future.completeExceptionally(cause);
            }
        });
        future.whenComplete((v, t) -> watch.close());
        return future;
    }
}

