/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.storage.VolumeAttachmentStatus;
import io.fabric8.kubernetes.api.model.storage.VolumeError;
import io.fabric8.kubernetes.api.model.storage.VolumeErrorBuilder;
import io.fabric8.kubernetes.api.model.storage.VolumeErrorFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class VolumeAttachmentStatusFluent<A extends VolumeAttachmentStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private VolumeErrorBuilder attachError;
    private Boolean attached;
    private Map<String, String> attachmentMetadata;
    private VolumeErrorBuilder detachError;

    public VolumeAttachmentStatusFluent() {
    }

    public VolumeAttachmentStatusFluent(VolumeAttachmentStatus instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAttachmentMetadata(Map<String, String> map) {
        if (this.attachmentMetadata == null && map != null) {
            this.attachmentMetadata = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.attachmentMetadata.putAll(map);
        }
        return (A)this;
    }

    public A addToAttachmentMetadata(String key, String value) {
        if (this.attachmentMetadata == null && key != null && value != null) {
            this.attachmentMetadata = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.attachmentMetadata.put(key, value);
        }
        return (A)this;
    }

    public VolumeError buildAttachError() {
        return this.attachError != null ? this.attachError.build() : null;
    }

    public VolumeError buildDetachError() {
        return this.detachError != null ? this.detachError.build() : null;
    }

    protected void copyInstance(VolumeAttachmentStatus instance) {
        VolumeAttachmentStatus volumeAttachmentStatus = instance = instance != null ? instance : new VolumeAttachmentStatus();
        if (instance != null) {
            this.withAttachError(instance.getAttachError());
            this.withAttached(instance.getAttached());
            this.withAttachmentMetadata(instance.getAttachmentMetadata());
            this.withDetachError(instance.getDetachError());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AttachErrorNested<A> editAttachError() {
        return this.withNewAttachErrorLike(Optional.ofNullable(this.buildAttachError()).orElse(null));
    }

    public DetachErrorNested<A> editDetachError() {
        return this.withNewDetachErrorLike(Optional.ofNullable(this.buildDetachError()).orElse(null));
    }

    public AttachErrorNested<A> editOrNewAttachError() {
        return this.withNewAttachErrorLike(Optional.ofNullable(this.buildAttachError()).orElse(new VolumeErrorBuilder().build()));
    }

    public AttachErrorNested<A> editOrNewAttachErrorLike(VolumeError item) {
        return this.withNewAttachErrorLike(Optional.ofNullable(this.buildAttachError()).orElse(item));
    }

    public DetachErrorNested<A> editOrNewDetachError() {
        return this.withNewDetachErrorLike(Optional.ofNullable(this.buildDetachError()).orElse(new VolumeErrorBuilder().build()));
    }

    public DetachErrorNested<A> editOrNewDetachErrorLike(VolumeError item) {
        return this.withNewDetachErrorLike(Optional.ofNullable(this.buildDetachError()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VolumeAttachmentStatusFluent that = (VolumeAttachmentStatusFluent)o;
        if (!Objects.equals(this.attachError, that.attachError)) {
            return false;
        }
        if (!Objects.equals(this.attached, that.attached)) {
            return false;
        }
        if (!Objects.equals(this.attachmentMetadata, that.attachmentMetadata)) {
            return false;
        }
        if (!Objects.equals(this.detachError, that.detachError)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Boolean getAttached() {
        return this.attached;
    }

    public Map<String, String> getAttachmentMetadata() {
        return this.attachmentMetadata;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAttachError() {
        return this.attachError != null;
    }

    public boolean hasAttached() {
        return this.attached != null;
    }

    public boolean hasAttachmentMetadata() {
        return this.attachmentMetadata != null;
    }

    public boolean hasDetachError() {
        return this.detachError != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.attachError, this.attached, this.attachmentMetadata, this.detachError, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromAttachmentMetadata(String key) {
        if (this.attachmentMetadata == null) {
            return (A)this;
        }
        if (key != null && this.attachmentMetadata != null) {
            this.attachmentMetadata.remove(key);
        }
        return (A)this;
    }

    public A removeFromAttachmentMetadata(Map<String, String> map) {
        if (this.attachmentMetadata == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.attachmentMetadata == null) continue;
                this.attachmentMetadata.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attachError != null) {
            sb.append("attachError:");
            sb.append(this.attachError);
            sb.append(",");
        }
        if (this.attached != null) {
            sb.append("attached:");
            sb.append(this.attached);
            sb.append(",");
        }
        if (this.attachmentMetadata != null && !this.attachmentMetadata.isEmpty()) {
            sb.append("attachmentMetadata:");
            sb.append(this.attachmentMetadata);
            sb.append(",");
        }
        if (this.detachError != null) {
            sb.append("detachError:");
            sb.append(this.detachError);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withAttachError(VolumeError attachError) {
        this._visitables.remove("attachError");
        if (attachError != null) {
            this.attachError = new VolumeErrorBuilder(attachError);
            this._visitables.get("attachError").add(this.attachError);
        } else {
            this.attachError = null;
            this._visitables.get("attachError").remove(this.attachError);
        }
        return (A)this;
    }

    public A withAttached() {
        return this.withAttached(true);
    }

    public A withAttached(Boolean attached) {
        this.attached = attached;
        return (A)this;
    }

    public <K, V> A withAttachmentMetadata(Map<String, String> attachmentMetadata) {
        this.attachmentMetadata = attachmentMetadata == null ? null : new LinkedHashMap<String, String>(attachmentMetadata);
        return (A)this;
    }

    public A withDetachError(VolumeError detachError) {
        this._visitables.remove("detachError");
        if (detachError != null) {
            this.detachError = new VolumeErrorBuilder(detachError);
            this._visitables.get("detachError").add(this.detachError);
        } else {
            this.detachError = null;
            this._visitables.get("detachError").remove(this.detachError);
        }
        return (A)this;
    }

    public AttachErrorNested<A> withNewAttachError() {
        return new AttachErrorNested(null);
    }

    public A withNewAttachError(Integer errorCode, String message, String time) {
        return this.withAttachError(new VolumeError(errorCode, message, time));
    }

    public AttachErrorNested<A> withNewAttachErrorLike(VolumeError item) {
        return new AttachErrorNested(item);
    }

    public DetachErrorNested<A> withNewDetachError() {
        return new DetachErrorNested(null);
    }

    public A withNewDetachError(Integer errorCode, String message, String time) {
        return this.withDetachError(new VolumeError(errorCode, message, time));
    }

    public DetachErrorNested<A> withNewDetachErrorLike(VolumeError item) {
        return new DetachErrorNested(item);
    }

    public class DetachErrorNested<N>
    extends VolumeErrorFluent<DetachErrorNested<N>>
    implements Nested<N> {
        VolumeErrorBuilder builder;

        DetachErrorNested(VolumeError item) {
            this.builder = new VolumeErrorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)VolumeAttachmentStatusFluent.this.withDetachError(this.builder.build());
        }

        public N endDetachError() {
            return this.and();
        }
    }

    public class AttachErrorNested<N>
    extends VolumeErrorFluent<AttachErrorNested<N>>
    implements Nested<N> {
        VolumeErrorBuilder builder;

        AttachErrorNested(VolumeError item) {
            this.builder = new VolumeErrorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)VolumeAttachmentStatusFluent.this.withAttachError(this.builder.build());
        }

        public N endAttachError() {
            return this.and();
        }
    }
}

