/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1beta2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.resource.v1beta2.CapacityRequirements;
import io.fabric8.kubernetes.api.model.resource.v1beta2.CapacityRequirementsBuilder;
import io.fabric8.kubernetes.api.model.resource.v1beta2.CapacityRequirementsFluent;
import io.fabric8.kubernetes.api.model.resource.v1beta2.DeviceSelector;
import io.fabric8.kubernetes.api.model.resource.v1beta2.DeviceSelectorBuilder;
import io.fabric8.kubernetes.api.model.resource.v1beta2.DeviceSelectorFluent;
import io.fabric8.kubernetes.api.model.resource.v1beta2.DeviceToleration;
import io.fabric8.kubernetes.api.model.resource.v1beta2.DeviceTolerationBuilder;
import io.fabric8.kubernetes.api.model.resource.v1beta2.DeviceTolerationFluent;
import io.fabric8.kubernetes.api.model.resource.v1beta2.ExactDeviceRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ExactDeviceRequestFluent<A extends ExactDeviceRequestFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Boolean adminAccess;
    private String allocationMode;
    private CapacityRequirementsBuilder capacity;
    private Long count;
    private String deviceClassName;
    private ArrayList<DeviceSelectorBuilder> selectors = new ArrayList();
    private ArrayList<DeviceTolerationBuilder> tolerations = new ArrayList();

    public ExactDeviceRequestFluent() {
    }

    public ExactDeviceRequestFluent(ExactDeviceRequest instance) {
        this.copyInstance(instance);
    }

    public A addAllToSelectors(Collection<DeviceSelector> items) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        for (DeviceSelector item : items) {
            DeviceSelectorBuilder builder = new DeviceSelectorBuilder(item);
            this._visitables.get("selectors").add(builder);
            this.selectors.add(builder);
        }
        return (A)this;
    }

    public A addAllToTolerations(Collection<DeviceToleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        for (DeviceToleration item : items) {
            DeviceTolerationBuilder builder = new DeviceTolerationBuilder(item);
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(builder);
        }
        return (A)this;
    }

    public SelectorsNested<A> addNewSelector() {
        return new SelectorsNested(-1, null);
    }

    public SelectorsNested<A> addNewSelectorLike(DeviceSelector item) {
        return new SelectorsNested(-1, item);
    }

    public TolerationsNested<A> addNewToleration() {
        return new TolerationsNested(-1, null);
    }

    public A addNewToleration(String effect, String key, String operator, Long tolerationSeconds, String value) {
        return this.addToTolerations(new DeviceToleration(effect, key, operator, tolerationSeconds, value));
    }

    public TolerationsNested<A> addNewTolerationLike(DeviceToleration item) {
        return new TolerationsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToSelectors(DeviceSelector ... items) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        for (DeviceSelector item : items) {
            DeviceSelectorBuilder builder = new DeviceSelectorBuilder(item);
            this._visitables.get("selectors").add(builder);
            this.selectors.add(builder);
        }
        return (A)this;
    }

    public A addToSelectors(int index, DeviceSelector item) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        DeviceSelectorBuilder builder = new DeviceSelectorBuilder(item);
        if (index < 0 || index >= this.selectors.size()) {
            this._visitables.get("selectors").add(builder);
            this.selectors.add(builder);
        } else {
            this._visitables.get("selectors").add(builder);
            this.selectors.add(index, builder);
        }
        return (A)this;
    }

    public A addToTolerations(DeviceToleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        for (DeviceToleration item : items) {
            DeviceTolerationBuilder builder = new DeviceTolerationBuilder(item);
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(builder);
        }
        return (A)this;
    }

    public A addToTolerations(int index, DeviceToleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        DeviceTolerationBuilder builder = new DeviceTolerationBuilder(item);
        if (index < 0 || index >= this.tolerations.size()) {
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(builder);
        } else {
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(index, builder);
        }
        return (A)this;
    }

    public CapacityRequirements buildCapacity() {
        return this.capacity != null ? this.capacity.build() : null;
    }

    public DeviceSelector buildFirstSelector() {
        return this.selectors.get(0).build();
    }

    public DeviceToleration buildFirstToleration() {
        return this.tolerations.get(0).build();
    }

    public DeviceSelector buildLastSelector() {
        return this.selectors.get(this.selectors.size() - 1).build();
    }

    public DeviceToleration buildLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1).build();
    }

    public DeviceSelector buildMatchingSelector(Predicate<DeviceSelectorBuilder> predicate) {
        for (DeviceSelectorBuilder item : this.selectors) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public DeviceToleration buildMatchingToleration(Predicate<DeviceTolerationBuilder> predicate) {
        for (DeviceTolerationBuilder item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public DeviceSelector buildSelector(int index) {
        return this.selectors.get(index).build();
    }

    public List<DeviceSelector> buildSelectors() {
        return this.selectors != null ? ExactDeviceRequestFluent.build(this.selectors) : null;
    }

    public DeviceToleration buildToleration(int index) {
        return this.tolerations.get(index).build();
    }

    public List<DeviceToleration> buildTolerations() {
        return this.tolerations != null ? ExactDeviceRequestFluent.build(this.tolerations) : null;
    }

    protected void copyInstance(ExactDeviceRequest instance) {
        ExactDeviceRequest exactDeviceRequest = instance = instance != null ? instance : new ExactDeviceRequest();
        if (instance != null) {
            this.withAdminAccess(instance.getAdminAccess());
            this.withAllocationMode(instance.getAllocationMode());
            this.withCapacity(instance.getCapacity());
            this.withCount(instance.getCount());
            this.withDeviceClassName(instance.getDeviceClassName());
            this.withSelectors(instance.getSelectors());
            this.withTolerations(instance.getTolerations());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public CapacityNested<A> editCapacity() {
        return this.withNewCapacityLike(Optional.ofNullable(this.buildCapacity()).orElse(null));
    }

    public SelectorsNested<A> editFirstSelector() {
        if (this.selectors.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "selectors"));
        }
        return this.setNewSelectorLike(0, this.buildSelector(0));
    }

    public TolerationsNested<A> editFirstToleration() {
        if (this.tolerations.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "tolerations"));
        }
        return this.setNewTolerationLike(0, this.buildToleration(0));
    }

    public SelectorsNested<A> editLastSelector() {
        int index = this.selectors.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "selectors"));
        }
        return this.setNewSelectorLike(index, this.buildSelector(index));
    }

    public TolerationsNested<A> editLastToleration() {
        int index = this.tolerations.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "tolerations"));
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    public SelectorsNested<A> editMatchingSelector(Predicate<DeviceSelectorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.selectors.size(); ++i) {
            if (!predicate.test(this.selectors.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "selectors"));
        }
        return this.setNewSelectorLike(index, this.buildSelector(index));
    }

    public TolerationsNested<A> editMatchingToleration(Predicate<DeviceTolerationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tolerations.size(); ++i) {
            if (!predicate.test(this.tolerations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "tolerations"));
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    public CapacityNested<A> editOrNewCapacity() {
        return this.withNewCapacityLike(Optional.ofNullable(this.buildCapacity()).orElse(new CapacityRequirementsBuilder().build()));
    }

    public CapacityNested<A> editOrNewCapacityLike(CapacityRequirements item) {
        return this.withNewCapacityLike(Optional.ofNullable(this.buildCapacity()).orElse(item));
    }

    public SelectorsNested<A> editSelector(int index) {
        if (this.selectors.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "selectors"));
        }
        return this.setNewSelectorLike(index, this.buildSelector(index));
    }

    public TolerationsNested<A> editToleration(int index) {
        if (this.tolerations.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "tolerations"));
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExactDeviceRequestFluent that = (ExactDeviceRequestFluent)o;
        if (!Objects.equals(this.adminAccess, that.adminAccess)) {
            return false;
        }
        if (!Objects.equals(this.allocationMode, that.allocationMode)) {
            return false;
        }
        if (!Objects.equals(this.capacity, that.capacity)) {
            return false;
        }
        if (!Objects.equals(this.count, that.count)) {
            return false;
        }
        if (!Objects.equals(this.deviceClassName, that.deviceClassName)) {
            return false;
        }
        if (!Objects.equals(this.selectors, that.selectors)) {
            return false;
        }
        if (!Objects.equals(this.tolerations, that.tolerations)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Boolean getAdminAccess() {
        return this.adminAccess;
    }

    public String getAllocationMode() {
        return this.allocationMode;
    }

    public Long getCount() {
        return this.count;
    }

    public String getDeviceClassName() {
        return this.deviceClassName;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAdminAccess() {
        return this.adminAccess != null;
    }

    public boolean hasAllocationMode() {
        return this.allocationMode != null;
    }

    public boolean hasCapacity() {
        return this.capacity != null;
    }

    public boolean hasCount() {
        return this.count != null;
    }

    public boolean hasDeviceClassName() {
        return this.deviceClassName != null;
    }

    public boolean hasMatchingSelector(Predicate<DeviceSelectorBuilder> predicate) {
        for (DeviceSelectorBuilder item : this.selectors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingToleration(Predicate<DeviceTolerationBuilder> predicate) {
        for (DeviceTolerationBuilder item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSelectors() {
        return this.selectors != null && !this.selectors.isEmpty();
    }

    public boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.adminAccess, this.allocationMode, this.capacity, this.count, this.deviceClassName, this.selectors, this.tolerations, this.additionalProperties);
    }

    public A removeAllFromSelectors(Collection<DeviceSelector> items) {
        if (this.selectors == null) {
            return (A)this;
        }
        for (DeviceSelector item : items) {
            DeviceSelectorBuilder builder = new DeviceSelectorBuilder(item);
            this._visitables.get("selectors").remove(builder);
            this.selectors.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromTolerations(Collection<DeviceToleration> items) {
        if (this.tolerations == null) {
            return (A)this;
        }
        for (DeviceToleration item : items) {
            DeviceTolerationBuilder builder = new DeviceTolerationBuilder(item);
            this._visitables.get("tolerations").remove(builder);
            this.tolerations.remove(builder);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromSelectors(DeviceSelector ... items) {
        if (this.selectors == null) {
            return (A)this;
        }
        for (DeviceSelector item : items) {
            DeviceSelectorBuilder builder = new DeviceSelectorBuilder(item);
            this._visitables.get("selectors").remove(builder);
            this.selectors.remove(builder);
        }
        return (A)this;
    }

    public A removeFromTolerations(DeviceToleration ... items) {
        if (this.tolerations == null) {
            return (A)this;
        }
        for (DeviceToleration item : items) {
            DeviceTolerationBuilder builder = new DeviceTolerationBuilder(item);
            this._visitables.get("tolerations").remove(builder);
            this.tolerations.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSelectors(Predicate<DeviceSelectorBuilder> predicate) {
        if (this.selectors == null) {
            return (A)this;
        }
        Iterator<DeviceSelectorBuilder> each = this.selectors.iterator();
        Object visitables = this._visitables.get("selectors");
        while (each.hasNext()) {
            DeviceSelectorBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public A removeMatchingFromTolerations(Predicate<DeviceTolerationBuilder> predicate) {
        if (this.tolerations == null) {
            return (A)this;
        }
        Iterator<DeviceTolerationBuilder> each = this.tolerations.iterator();
        Object visitables = this._visitables.get("tolerations");
        while (each.hasNext()) {
            DeviceTolerationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public SelectorsNested<A> setNewSelectorLike(int index, DeviceSelector item) {
        return new SelectorsNested(index, item);
    }

    public TolerationsNested<A> setNewTolerationLike(int index, DeviceToleration item) {
        return new TolerationsNested(index, item);
    }

    public A setToSelectors(int index, DeviceSelector item) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        DeviceSelectorBuilder builder = new DeviceSelectorBuilder(item);
        if (index < 0 || index >= this.selectors.size()) {
            this._visitables.get("selectors").add(builder);
            this.selectors.add(builder);
        } else {
            this._visitables.get("selectors").add(builder);
            this.selectors.set(index, builder);
        }
        return (A)this;
    }

    public A setToTolerations(int index, DeviceToleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        DeviceTolerationBuilder builder = new DeviceTolerationBuilder(item);
        if (index < 0 || index >= this.tolerations.size()) {
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(builder);
        } else {
            this._visitables.get("tolerations").add(builder);
            this.tolerations.set(index, builder);
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.adminAccess != null) {
            sb.append("adminAccess:");
            sb.append(this.adminAccess);
            sb.append(",");
        }
        if (this.allocationMode != null) {
            sb.append("allocationMode:");
            sb.append(this.allocationMode);
            sb.append(",");
        }
        if (this.capacity != null) {
            sb.append("capacity:");
            sb.append(this.capacity);
            sb.append(",");
        }
        if (this.count != null) {
            sb.append("count:");
            sb.append(this.count);
            sb.append(",");
        }
        if (this.deviceClassName != null) {
            sb.append("deviceClassName:");
            sb.append(this.deviceClassName);
            sb.append(",");
        }
        if (this.selectors != null && !this.selectors.isEmpty()) {
            sb.append("selectors:");
            sb.append(this.selectors);
            sb.append(",");
        }
        if (this.tolerations != null && !this.tolerations.isEmpty()) {
            sb.append("tolerations:");
            sb.append(this.tolerations);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withAdminAccess() {
        return this.withAdminAccess(true);
    }

    public A withAdminAccess(Boolean adminAccess) {
        this.adminAccess = adminAccess;
        return (A)this;
    }

    public A withAllocationMode(String allocationMode) {
        this.allocationMode = allocationMode;
        return (A)this;
    }

    public A withCapacity(CapacityRequirements capacity) {
        this._visitables.remove("capacity");
        if (capacity != null) {
            this.capacity = new CapacityRequirementsBuilder(capacity);
            this._visitables.get("capacity").add(this.capacity);
        } else {
            this.capacity = null;
            this._visitables.get("capacity").remove(this.capacity);
        }
        return (A)this;
    }

    public A withCount(Long count) {
        this.count = count;
        return (A)this;
    }

    public A withDeviceClassName(String deviceClassName) {
        this.deviceClassName = deviceClassName;
        return (A)this;
    }

    public CapacityNested<A> withNewCapacity() {
        return new CapacityNested(null);
    }

    public CapacityNested<A> withNewCapacityLike(CapacityRequirements item) {
        return new CapacityNested(item);
    }

    public A withSelectors(List<DeviceSelector> selectors) {
        if (this.selectors != null) {
            this._visitables.get("selectors").clear();
        }
        if (selectors != null) {
            this.selectors = new ArrayList();
            for (DeviceSelector item : selectors) {
                this.addToSelectors(item);
            }
        } else {
            this.selectors = null;
        }
        return (A)this;
    }

    public A withSelectors(DeviceSelector ... selectors) {
        if (this.selectors != null) {
            this.selectors.clear();
            this._visitables.remove("selectors");
        }
        if (selectors != null) {
            for (DeviceSelector item : selectors) {
                this.addToSelectors(item);
            }
        }
        return (A)this;
    }

    public A withTolerations(List<DeviceToleration> tolerations) {
        if (this.tolerations != null) {
            this._visitables.get("tolerations").clear();
        }
        if (tolerations != null) {
            this.tolerations = new ArrayList();
            for (DeviceToleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)this;
    }

    public A withTolerations(DeviceToleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
            this._visitables.remove("tolerations");
        }
        if (tolerations != null) {
            for (DeviceToleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)this;
    }

    public class TolerationsNested<N>
    extends DeviceTolerationFluent<TolerationsNested<N>>
    implements Nested<N> {
        DeviceTolerationBuilder builder;
        int index;

        TolerationsNested(int index, DeviceToleration item) {
            this.index = index;
            this.builder = new DeviceTolerationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ExactDeviceRequestFluent.this.setToTolerations(this.index, this.builder.build());
        }

        public N endToleration() {
            return this.and();
        }
    }

    public class SelectorsNested<N>
    extends DeviceSelectorFluent<SelectorsNested<N>>
    implements Nested<N> {
        DeviceSelectorBuilder builder;
        int index;

        SelectorsNested(int index, DeviceSelector item) {
            this.index = index;
            this.builder = new DeviceSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ExactDeviceRequestFluent.this.setToSelectors(this.index, this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }

    public class CapacityNested<N>
    extends CapacityRequirementsFluent<CapacityNested<N>>
    implements Nested<N> {
        CapacityRequirementsBuilder builder;

        CapacityNested(CapacityRequirements item) {
            this.builder = new CapacityRequirementsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ExactDeviceRequestFluent.this.withCapacity(this.builder.build());
        }

        public N endCapacity() {
            return this.and();
        }
    }
}

