/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.model.resource.v1beta1.AllocatedDeviceStatus;
import io.fabric8.kubernetes.api.model.resource.v1beta1.NetworkDeviceData;
import io.fabric8.kubernetes.api.model.resource.v1beta1.NetworkDeviceDataBuilder;
import io.fabric8.kubernetes.api.model.resource.v1beta1.NetworkDeviceDataFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class AllocatedDeviceStatusFluent<A extends AllocatedDeviceStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private List<Condition> conditions = new ArrayList<Condition>();
    private Object data;
    private String device;
    private String driver;
    private NetworkDeviceDataBuilder networkData;
    private String pool;
    private String shareID;

    public AllocatedDeviceStatusFluent() {
    }

    public AllocatedDeviceStatusFluent(AllocatedDeviceStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    public NetworkDeviceData buildNetworkData() {
        return this.networkData != null ? this.networkData.build() : null;
    }

    protected void copyInstance(AllocatedDeviceStatus instance) {
        AllocatedDeviceStatus allocatedDeviceStatus = instance = instance != null ? instance : new AllocatedDeviceStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withData(instance.getData());
            this.withDevice(instance.getDevice());
            this.withDriver(instance.getDriver());
            this.withNetworkData(instance.getNetworkData());
            this.withPool(instance.getPool());
            this.withShareID(instance.getShareID());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public NetworkDataNested<A> editNetworkData() {
        return this.withNewNetworkDataLike(Optional.ofNullable(this.buildNetworkData()).orElse(null));
    }

    public NetworkDataNested<A> editOrNewNetworkData() {
        return this.withNewNetworkDataLike(Optional.ofNullable(this.buildNetworkData()).orElse(new NetworkDeviceDataBuilder().build()));
    }

    public NetworkDataNested<A> editOrNewNetworkDataLike(NetworkDeviceData item) {
        return this.withNewNetworkDataLike(Optional.ofNullable(this.buildNetworkData()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AllocatedDeviceStatusFluent that = (AllocatedDeviceStatusFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.data, that.data)) {
            return false;
        }
        if (!Objects.equals(this.device, that.device)) {
            return false;
        }
        if (!Objects.equals(this.driver, that.driver)) {
            return false;
        }
        if (!Objects.equals(this.networkData, that.networkData)) {
            return false;
        }
        if (!Objects.equals(this.pool, that.pool)) {
            return false;
        }
        if (!Objects.equals(this.shareID, that.shareID)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Object getData() {
        return this.data;
    }

    public String getDevice() {
        return this.device;
    }

    public String getDriver() {
        return this.driver;
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getPool() {
        return this.pool;
    }

    public String getShareID() {
        return this.shareID;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean hasData() {
        return this.data != null;
    }

    public boolean hasDevice() {
        return this.device != null;
    }

    public boolean hasDriver() {
        return this.driver != null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNetworkData() {
        return this.networkData != null;
    }

    public boolean hasPool() {
        return this.pool != null;
    }

    public boolean hasShareID() {
        return this.shareID != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.data, this.device, this.driver, this.networkData, this.pool, this.shareID, this.additionalProperties);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
            sb.append(",");
        }
        if (this.data != null) {
            sb.append("data:");
            sb.append(this.data);
            sb.append(",");
        }
        if (this.device != null) {
            sb.append("device:");
            sb.append(this.device);
            sb.append(",");
        }
        if (this.driver != null) {
            sb.append("driver:");
            sb.append(this.driver);
            sb.append(",");
        }
        if (this.networkData != null) {
            sb.append("networkData:");
            sb.append(this.networkData);
            sb.append(",");
        }
        if (this.pool != null) {
            sb.append("pool:");
            sb.append(this.pool);
            sb.append(",");
        }
        if (this.shareID != null) {
            sb.append("shareID:");
            sb.append(this.shareID);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public A withData(Object data) {
        this.data = data;
        return (A)this;
    }

    public A withDevice(String device) {
        this.device = device;
        return (A)this;
    }

    public A withDriver(String driver) {
        this.driver = driver;
        return (A)this;
    }

    public A withNetworkData(NetworkDeviceData networkData) {
        this._visitables.remove("networkData");
        if (networkData != null) {
            this.networkData = new NetworkDeviceDataBuilder(networkData);
            this._visitables.get("networkData").add(this.networkData);
        } else {
            this.networkData = null;
            this._visitables.get("networkData").remove(this.networkData);
        }
        return (A)this;
    }

    public NetworkDataNested<A> withNewNetworkData() {
        return new NetworkDataNested(null);
    }

    public NetworkDataNested<A> withNewNetworkDataLike(NetworkDeviceData item) {
        return new NetworkDataNested(item);
    }

    public A withPool(String pool) {
        this.pool = pool;
        return (A)this;
    }

    public A withShareID(String shareID) {
        this.shareID = shareID;
        return (A)this;
    }

    public class NetworkDataNested<N>
    extends NetworkDeviceDataFluent<NetworkDataNested<N>>
    implements Nested<N> {
        NetworkDeviceDataBuilder builder;

        NetworkDataNested(NetworkDeviceData item) {
            this.builder = new NetworkDeviceDataBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AllocatedDeviceStatusFluent.this.withNetworkData(this.builder.build());
        }

        public N endNetworkData() {
            return this.and();
        }
    }
}

