/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.BackendObjectReference;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.BackendObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.BackendObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.Fraction;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.FractionBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.FractionFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.HTTPRequestMirrorFilter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HTTPRequestMirrorFilterFluent<A extends HTTPRequestMirrorFilterFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private BackendObjectReferenceBuilder backendRef;
    private FractionBuilder fraction;
    private Integer percent;

    public HTTPRequestMirrorFilterFluent() {
    }

    public HTTPRequestMirrorFilterFluent(HTTPRequestMirrorFilter instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public BackendObjectReference buildBackendRef() {
        return this.backendRef != null ? this.backendRef.build() : null;
    }

    public Fraction buildFraction() {
        return this.fraction != null ? this.fraction.build() : null;
    }

    protected void copyInstance(HTTPRequestMirrorFilter instance) {
        HTTPRequestMirrorFilter hTTPRequestMirrorFilter = instance = instance != null ? instance : new HTTPRequestMirrorFilter();
        if (instance != null) {
            this.withBackendRef(instance.getBackendRef());
            this.withFraction(instance.getFraction());
            this.withPercent(instance.getPercent());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public BackendRefNested<A> editBackendRef() {
        return this.withNewBackendRefLike(Optional.ofNullable(this.buildBackendRef()).orElse(null));
    }

    public FractionNested<A> editFraction() {
        return this.withNewFractionLike(Optional.ofNullable(this.buildFraction()).orElse(null));
    }

    public BackendRefNested<A> editOrNewBackendRef() {
        return this.withNewBackendRefLike(Optional.ofNullable(this.buildBackendRef()).orElse(new BackendObjectReferenceBuilder().build()));
    }

    public BackendRefNested<A> editOrNewBackendRefLike(BackendObjectReference item) {
        return this.withNewBackendRefLike(Optional.ofNullable(this.buildBackendRef()).orElse(item));
    }

    public FractionNested<A> editOrNewFraction() {
        return this.withNewFractionLike(Optional.ofNullable(this.buildFraction()).orElse(new FractionBuilder().build()));
    }

    public FractionNested<A> editOrNewFractionLike(Fraction item) {
        return this.withNewFractionLike(Optional.ofNullable(this.buildFraction()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPRequestMirrorFilterFluent that = (HTTPRequestMirrorFilterFluent)o;
        if (!Objects.equals(this.backendRef, that.backendRef)) {
            return false;
        }
        if (!Objects.equals(this.fraction, that.fraction)) {
            return false;
        }
        if (!Objects.equals(this.percent, that.percent)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Integer getPercent() {
        return this.percent;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasBackendRef() {
        return this.backendRef != null;
    }

    public boolean hasFraction() {
        return this.fraction != null;
    }

    public boolean hasPercent() {
        return this.percent != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.backendRef, this.fraction, this.percent, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.backendRef != null) {
            sb.append("backendRef:");
            sb.append(this.backendRef);
            sb.append(",");
        }
        if (this.fraction != null) {
            sb.append("fraction:");
            sb.append(this.fraction);
            sb.append(",");
        }
        if (this.percent != null) {
            sb.append("percent:");
            sb.append(this.percent);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withBackendRef(BackendObjectReference backendRef) {
        this._visitables.remove("backendRef");
        if (backendRef != null) {
            this.backendRef = new BackendObjectReferenceBuilder(backendRef);
            this._visitables.get("backendRef").add(this.backendRef);
        } else {
            this.backendRef = null;
            this._visitables.get("backendRef").remove(this.backendRef);
        }
        return (A)this;
    }

    public A withFraction(Fraction fraction) {
        this._visitables.remove("fraction");
        if (fraction != null) {
            this.fraction = new FractionBuilder(fraction);
            this._visitables.get("fraction").add(this.fraction);
        } else {
            this.fraction = null;
            this._visitables.get("fraction").remove(this.fraction);
        }
        return (A)this;
    }

    public BackendRefNested<A> withNewBackendRef() {
        return new BackendRefNested(null);
    }

    public A withNewBackendRef(String group, String kind, String name, String namespace, Integer port) {
        return this.withBackendRef(new BackendObjectReference(group, kind, name, namespace, port));
    }

    public BackendRefNested<A> withNewBackendRefLike(BackendObjectReference item) {
        return new BackendRefNested(item);
    }

    public FractionNested<A> withNewFraction() {
        return new FractionNested(null);
    }

    public A withNewFraction(Integer denominator, Integer numerator) {
        return this.withFraction(new Fraction(denominator, numerator));
    }

    public FractionNested<A> withNewFractionLike(Fraction item) {
        return new FractionNested(item);
    }

    public A withPercent(Integer percent) {
        this.percent = percent;
        return (A)this;
    }

    public class FractionNested<N>
    extends FractionFluent<FractionNested<N>>
    implements Nested<N> {
        FractionBuilder builder;

        FractionNested(Fraction item) {
            this.builder = new FractionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HTTPRequestMirrorFilterFluent.this.withFraction(this.builder.build());
        }

        public N endFraction() {
            return this.and();
        }
    }

    public class BackendRefNested<N>
    extends BackendObjectReferenceFluent<BackendRefNested<N>>
    implements Nested<N> {
        BackendObjectReferenceBuilder builder;

        BackendRefNested(BackendObjectReference item) {
            this.builder = new BackendObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HTTPRequestMirrorFilterFluent.this.withBackendRef(this.builder.build());
        }

        public N endBackendRef() {
            return this.and();
        }
    }
}

