/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.CommonRouteSpec;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.ParentReference;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.ParentReferenceBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.ParentReferenceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class CommonRouteSpecFluent<A extends CommonRouteSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<ParentReferenceBuilder> parentRefs = new ArrayList();
    private String useDefaultGateways;

    public CommonRouteSpecFluent() {
    }

    public CommonRouteSpecFluent(CommonRouteSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToParentRefs(Collection<ParentReference> items) {
        if (this.parentRefs == null) {
            this.parentRefs = new ArrayList();
        }
        for (ParentReference item : items) {
            ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
            this._visitables.get("parentRefs").add(builder);
            this.parentRefs.add(builder);
        }
        return (A)this;
    }

    public ParentRefsNested<A> addNewParentRef() {
        return new ParentRefsNested(-1, null);
    }

    public ParentRefsNested<A> addNewParentRefLike(ParentReference item) {
        return new ParentRefsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToParentRefs(ParentReference ... items) {
        if (this.parentRefs == null) {
            this.parentRefs = new ArrayList();
        }
        for (ParentReference item : items) {
            ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
            this._visitables.get("parentRefs").add(builder);
            this.parentRefs.add(builder);
        }
        return (A)this;
    }

    public A addToParentRefs(int index, ParentReference item) {
        if (this.parentRefs == null) {
            this.parentRefs = new ArrayList();
        }
        ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
        if (index < 0 || index >= this.parentRefs.size()) {
            this._visitables.get("parentRefs").add(builder);
            this.parentRefs.add(builder);
        } else {
            this._visitables.get("parentRefs").add(builder);
            this.parentRefs.add(index, builder);
        }
        return (A)this;
    }

    public ParentReference buildFirstParentRef() {
        return this.parentRefs.get(0).build();
    }

    public ParentReference buildLastParentRef() {
        return this.parentRefs.get(this.parentRefs.size() - 1).build();
    }

    public ParentReference buildMatchingParentRef(Predicate<ParentReferenceBuilder> predicate) {
        for (ParentReferenceBuilder item : this.parentRefs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public ParentReference buildParentRef(int index) {
        return this.parentRefs.get(index).build();
    }

    public List<ParentReference> buildParentRefs() {
        return this.parentRefs != null ? CommonRouteSpecFluent.build(this.parentRefs) : null;
    }

    protected void copyInstance(CommonRouteSpec instance) {
        CommonRouteSpec commonRouteSpec = instance = instance != null ? instance : new CommonRouteSpec();
        if (instance != null) {
            this.withParentRefs(instance.getParentRefs());
            this.withUseDefaultGateways(instance.getUseDefaultGateways());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ParentRefsNested<A> editFirstParentRef() {
        if (this.parentRefs.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "parentRefs"));
        }
        return this.setNewParentRefLike(0, this.buildParentRef(0));
    }

    public ParentRefsNested<A> editLastParentRef() {
        int index = this.parentRefs.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "parentRefs"));
        }
        return this.setNewParentRefLike(index, this.buildParentRef(index));
    }

    public ParentRefsNested<A> editMatchingParentRef(Predicate<ParentReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.parentRefs.size(); ++i) {
            if (!predicate.test(this.parentRefs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "parentRefs"));
        }
        return this.setNewParentRefLike(index, this.buildParentRef(index));
    }

    public ParentRefsNested<A> editParentRef(int index) {
        if (this.parentRefs.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "parentRefs"));
        }
        return this.setNewParentRefLike(index, this.buildParentRef(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CommonRouteSpecFluent that = (CommonRouteSpecFluent)o;
        if (!Objects.equals(this.parentRefs, that.parentRefs)) {
            return false;
        }
        if (!Objects.equals(this.useDefaultGateways, that.useDefaultGateways)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getUseDefaultGateways() {
        return this.useDefaultGateways;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasMatchingParentRef(Predicate<ParentReferenceBuilder> predicate) {
        for (ParentReferenceBuilder item : this.parentRefs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasParentRefs() {
        return this.parentRefs != null && !this.parentRefs.isEmpty();
    }

    public boolean hasUseDefaultGateways() {
        return this.useDefaultGateways != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.parentRefs, this.useDefaultGateways, this.additionalProperties);
    }

    public A removeAllFromParentRefs(Collection<ParentReference> items) {
        if (this.parentRefs == null) {
            return (A)this;
        }
        for (ParentReference item : items) {
            ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
            this._visitables.get("parentRefs").remove(builder);
            this.parentRefs.remove(builder);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromParentRefs(ParentReference ... items) {
        if (this.parentRefs == null) {
            return (A)this;
        }
        for (ParentReference item : items) {
            ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
            this._visitables.get("parentRefs").remove(builder);
            this.parentRefs.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromParentRefs(Predicate<ParentReferenceBuilder> predicate) {
        if (this.parentRefs == null) {
            return (A)this;
        }
        Iterator<ParentReferenceBuilder> each = this.parentRefs.iterator();
        Object visitables = this._visitables.get("parentRefs");
        while (each.hasNext()) {
            ParentReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public ParentRefsNested<A> setNewParentRefLike(int index, ParentReference item) {
        return new ParentRefsNested(index, item);
    }

    public A setToParentRefs(int index, ParentReference item) {
        if (this.parentRefs == null) {
            this.parentRefs = new ArrayList();
        }
        ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
        if (index < 0 || index >= this.parentRefs.size()) {
            this._visitables.get("parentRefs").add(builder);
            this.parentRefs.add(builder);
        } else {
            this._visitables.get("parentRefs").add(builder);
            this.parentRefs.set(index, builder);
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.parentRefs != null && !this.parentRefs.isEmpty()) {
            sb.append("parentRefs:");
            sb.append(this.parentRefs);
            sb.append(",");
        }
        if (this.useDefaultGateways != null) {
            sb.append("useDefaultGateways:");
            sb.append(this.useDefaultGateways);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withParentRefs(List<ParentReference> parentRefs) {
        if (this.parentRefs != null) {
            this._visitables.get("parentRefs").clear();
        }
        if (parentRefs != null) {
            this.parentRefs = new ArrayList();
            for (ParentReference item : parentRefs) {
                this.addToParentRefs(item);
            }
        } else {
            this.parentRefs = null;
        }
        return (A)this;
    }

    public A withParentRefs(ParentReference ... parentRefs) {
        if (this.parentRefs != null) {
            this.parentRefs.clear();
            this._visitables.remove("parentRefs");
        }
        if (parentRefs != null) {
            for (ParentReference item : parentRefs) {
                this.addToParentRefs(item);
            }
        }
        return (A)this;
    }

    public A withUseDefaultGateways(String useDefaultGateways) {
        this.useDefaultGateways = useDefaultGateways;
        return (A)this;
    }

    public class ParentRefsNested<N>
    extends ParentReferenceFluent<ParentRefsNested<N>>
    implements Nested<N> {
        ParentReferenceBuilder builder;
        int index;

        ParentRefsNested(int index, ParentReference item) {
            this.index = index;
            this.builder = new ParentReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CommonRouteSpecFluent.this.setToParentRefs(this.index, this.builder.build());
        }

        public N endParentRef() {
            return this.and();
        }
    }
}

