/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.NodeSelectorTerm;
import io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder;
import io.fabric8.kubernetes.api.model.NodeSelectorTermFluent;
import io.fabric8.kubernetes.api.model.PreferredSchedulingTerm;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PreferredSchedulingTermFluent<A extends PreferredSchedulingTermFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private NodeSelectorTermBuilder preference;
    private Integer weight;

    public PreferredSchedulingTermFluent() {
    }

    public PreferredSchedulingTermFluent(PreferredSchedulingTerm instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public NodeSelectorTerm buildPreference() {
        return this.preference != null ? this.preference.build() : null;
    }

    protected void copyInstance(PreferredSchedulingTerm instance) {
        PreferredSchedulingTerm preferredSchedulingTerm = instance = instance != null ? instance : new PreferredSchedulingTerm();
        if (instance != null) {
            this.withPreference(instance.getPreference());
            this.withWeight(instance.getWeight());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public PreferenceNested<A> editOrNewPreference() {
        return this.withNewPreferenceLike(Optional.ofNullable(this.buildPreference()).orElse(new NodeSelectorTermBuilder().build()));
    }

    public PreferenceNested<A> editOrNewPreferenceLike(NodeSelectorTerm item) {
        return this.withNewPreferenceLike(Optional.ofNullable(this.buildPreference()).orElse(item));
    }

    public PreferenceNested<A> editPreference() {
        return this.withNewPreferenceLike(Optional.ofNullable(this.buildPreference()).orElse(null));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PreferredSchedulingTermFluent that = (PreferredSchedulingTermFluent)o;
        if (!Objects.equals(this.preference, that.preference)) {
            return false;
        }
        if (!Objects.equals(this.weight, that.weight)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasPreference() {
        return this.preference != null;
    }

    public boolean hasWeight() {
        return this.weight != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.preference, this.weight, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.preference != null) {
            sb.append("preference:");
            sb.append(this.preference);
            sb.append(",");
        }
        if (this.weight != null) {
            sb.append("weight:");
            sb.append(this.weight);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public PreferenceNested<A> withNewPreference() {
        return new PreferenceNested(null);
    }

    public PreferenceNested<A> withNewPreferenceLike(NodeSelectorTerm item) {
        return new PreferenceNested(item);
    }

    public A withPreference(NodeSelectorTerm preference) {
        this._visitables.remove("preference");
        if (preference != null) {
            this.preference = new NodeSelectorTermBuilder(preference);
            this._visitables.get("preference").add(this.preference);
        } else {
            this.preference = null;
            this._visitables.get("preference").remove(this.preference);
        }
        return (A)this;
    }

    public A withWeight(Integer weight) {
        this.weight = weight;
        return (A)this;
    }

    public class PreferenceNested<N>
    extends NodeSelectorTermFluent<PreferenceNested<N>>
    implements Nested<N> {
        NodeSelectorTermBuilder builder;

        PreferenceNested(NodeSelectorTerm item) {
            this.builder = new NodeSelectorTermBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PreferredSchedulingTermFluent.this.withPreference(this.builder.build());
        }

        public N endPreference() {
            return this.and();
        }
    }
}

