/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ConfigMapProjection;
import io.fabric8.kubernetes.api.model.KeyToPath;
import io.fabric8.kubernetes.api.model.KeyToPathBuilder;
import io.fabric8.kubernetes.api.model.KeyToPathFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ConfigMapProjectionFluent<A extends ConfigMapProjectionFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<KeyToPathBuilder> items = new ArrayList();
    private String name;
    private Boolean optional;

    public ConfigMapProjectionFluent() {
    }

    public ConfigMapProjectionFluent(ConfigMapProjection instance) {
        this.copyInstance(instance);
    }

    public A addAllToItems(Collection<KeyToPath> items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (KeyToPath item : items) {
            KeyToPathBuilder builder = new KeyToPathBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    public ItemsNested<A> addNewItem() {
        return new ItemsNested(-1, null);
    }

    public A addNewItem(String key, Integer mode, String path) {
        return this.addToItems(new KeyToPath(key, mode, path));
    }

    public ItemsNested<A> addNewItemLike(KeyToPath item) {
        return new ItemsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToItems(KeyToPath ... items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (KeyToPath item : items) {
            KeyToPathBuilder builder = new KeyToPathBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    public A addToItems(int index, KeyToPath item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        KeyToPathBuilder builder = new KeyToPathBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get("items").add(builder);
            this.items.add(index, builder);
        }
        return (A)this;
    }

    public KeyToPath buildFirstItem() {
        return this.items.get(0).build();
    }

    public KeyToPath buildItem(int index) {
        return this.items.get(index).build();
    }

    public List<KeyToPath> buildItems() {
        return this.items != null ? ConfigMapProjectionFluent.build(this.items) : null;
    }

    public KeyToPath buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    public KeyToPath buildMatchingItem(Predicate<KeyToPathBuilder> predicate) {
        for (KeyToPathBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(ConfigMapProjection instance) {
        ConfigMapProjection configMapProjection = instance = instance != null ? instance : new ConfigMapProjection();
        if (instance != null) {
            this.withItems(instance.getItems());
            this.withName(instance.getName());
            this.withOptional(instance.getOptional());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "items"));
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    public ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "items"));
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "items"));
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editMatchingItem(Predicate<KeyToPathBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "items"));
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigMapProjectionFluent that = (ConfigMapProjectionFluent)o;
        if (!Objects.equals(this.items, that.items)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.optional, that.optional)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getOptional() {
        return this.optional;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    public boolean hasMatchingItem(Predicate<KeyToPathBuilder> predicate) {
        for (KeyToPathBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasOptional() {
        return this.optional != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.items, this.name, this.optional, this.additionalProperties);
    }

    public A removeAllFromItems(Collection<KeyToPath> items) {
        if (this.items == null) {
            return (A)this;
        }
        for (KeyToPath item : items) {
            KeyToPathBuilder builder = new KeyToPathBuilder(item);
            this._visitables.get("items").remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromItems(KeyToPath ... items) {
        if (this.items == null) {
            return (A)this;
        }
        for (KeyToPath item : items) {
            KeyToPathBuilder builder = new KeyToPathBuilder(item);
            this._visitables.get("items").remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromItems(Predicate<KeyToPathBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<KeyToPathBuilder> each = this.items.iterator();
        Object visitables = this._visitables.get("items");
        while (each.hasNext()) {
            KeyToPathBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public ItemsNested<A> setNewItemLike(int index, KeyToPath item) {
        return new ItemsNested(index, item);
    }

    public A setToItems(int index, KeyToPath item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        KeyToPathBuilder builder = new KeyToPathBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get("items").add(builder);
            this.items.set(index, builder);
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.items != null && !this.items.isEmpty()) {
            sb.append("items:");
            sb.append(this.items);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.optional != null) {
            sb.append("optional:");
            sb.append(this.optional);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withItems(List<KeyToPath> items) {
        if (this.items != null) {
            this._visitables.get("items").clear();
        }
        if (items != null) {
            this.items = new ArrayList();
            for (KeyToPath item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    public A withItems(KeyToPath ... items) {
        if (this.items != null) {
            this.items.clear();
            this._visitables.remove("items");
        }
        if (items != null) {
            for (KeyToPath item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public A withOptional() {
        return this.withOptional(true);
    }

    public A withOptional(Boolean optional) {
        this.optional = optional;
        return (A)this;
    }

    public class ItemsNested<N>
    extends KeyToPathFluent<ItemsNested<N>>
    implements Nested<N> {
        KeyToPathBuilder builder;
        int index;

        ItemsNested(int index, KeyToPath item) {
            this.index = index;
            this.builder = new KeyToPathBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ConfigMapProjectionFluent.this.setToItems(this.index, this.builder.build());
        }

        public N endItem() {
            return this.and();
        }
    }
}

