/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crdv2.generator.v1;

import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps;
import io.fabric8.kubernetes.client.utils.KubernetesSerialization;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Repeatable(value=List.class)
public @interface SchemaCustomizer {
    public Class<? extends Customizer> value();

    public String input() default "";

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface List {
        public SchemaCustomizer[] value();
    }

    public static class MergePatchCustomizer
    implements Customizer {
        @Override
        public JSONSchemaProps apply(JSONSchemaProps props, String input, KubernetesSerialization kubernetesSerialization) {
            kubernetesSerialization.mergePatch(props, input);
            return props;
        }
    }

    public static class RawCustomizer
    implements Customizer {
        @Override
        public JSONSchemaProps apply(JSONSchemaProps props, String input, KubernetesSerialization kubernetesSerialization) {
            return kubernetesSerialization.unmarshal(input, JSONSchemaProps.class);
        }
    }

    public static interface Customizer {
        public JSONSchemaProps apply(JSONSchemaProps var1, String var2, KubernetesSerialization var3);
    }
}

