/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarSource;
import io.fabric8.kubernetes.api.model.EnvVarSourceBuilder;
import io.fabric8.kubernetes.api.model.EnvVarSourceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class EnvVarFluent<A extends EnvVarFluent<A>>
extends BaseFluent<A> {
    private String name;
    private String value;
    private EnvVarSourceBuilder valueFrom;
    private Map<String, Object> additionalProperties;

    public EnvVarFluent() {
    }

    public EnvVarFluent(EnvVar instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(EnvVar instance) {
        EnvVar envVar = instance = instance != null ? instance : new EnvVar();
        if (instance != null) {
            this.withName(instance.getName());
            this.withValue(instance.getValue());
            this.withValueFrom(instance.getValueFrom());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getValue() {
        return this.value;
    }

    public A withValue(String value) {
        this.value = value;
        return (A)this;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public EnvVarSource buildValueFrom() {
        return this.valueFrom != null ? this.valueFrom.build() : null;
    }

    public A withValueFrom(EnvVarSource valueFrom) {
        this._visitables.remove("valueFrom");
        if (valueFrom != null) {
            this.valueFrom = new EnvVarSourceBuilder(valueFrom);
            this._visitables.get("valueFrom").add(this.valueFrom);
        } else {
            this.valueFrom = null;
            this._visitables.get("valueFrom").remove(this.valueFrom);
        }
        return (A)this;
    }

    public boolean hasValueFrom() {
        return this.valueFrom != null;
    }

    public ValueFromNested<A> withNewValueFrom() {
        return new ValueFromNested(null);
    }

    public ValueFromNested<A> withNewValueFromLike(EnvVarSource item) {
        return new ValueFromNested(item);
    }

    public ValueFromNested<A> editValueFrom() {
        return this.withNewValueFromLike(Optional.ofNullable(this.buildValueFrom()).orElse(null));
    }

    public ValueFromNested<A> editOrNewValueFrom() {
        return this.withNewValueFromLike(Optional.ofNullable(this.buildValueFrom()).orElse(new EnvVarSourceBuilder().build()));
    }

    public ValueFromNested<A> editOrNewValueFromLike(EnvVarSource item) {
        return this.withNewValueFromLike(Optional.ofNullable(this.buildValueFrom()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EnvVarFluent that = (EnvVarFluent)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.value, that.value)) {
            return false;
        }
        if (!Objects.equals(this.valueFrom, that.valueFrom)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.value, this.valueFrom, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.value != null) {
            sb.append("value:");
            sb.append(this.value + ",");
        }
        if (this.valueFrom != null) {
            sb.append("valueFrom:");
            sb.append(String.valueOf(this.valueFrom) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ValueFromNested<N>
    extends EnvVarSourceFluent<ValueFromNested<N>>
    implements Nested<N> {
        EnvVarSourceBuilder builder;

        ValueFromNested(EnvVarSource item) {
            this.builder = new EnvVarSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EnvVarFluent.this.withValueFrom(this.builder.build());
        }

        public N endValueFrom() {
            return this.and();
        }
    }
}

