/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crdv2.generator;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public class InternalSchemaSwaps {
    private final Map<Key, Value> parentSwaps;
    private final Map<Key, Value> swaps;
    private final Map<Key, Integer> swapDepths;

    public InternalSchemaSwaps() {
        this(new HashMap<Key, Value>(), new HashMap<Key, Integer>(), new HashMap<Key, Value>());
    }

    private InternalSchemaSwaps(Map<Key, Value> swaps, Map<Key, Integer> swapDepths, Map<Key, Value> parentSwaps) {
        this.parentSwaps = parentSwaps;
        this.swaps = swaps;
        this.swapDepths = swapDepths;
    }

    public InternalSchemaSwaps branchDepths() {
        InternalSchemaSwaps result = new InternalSchemaSwaps(this.swaps, new HashMap<Key, Integer>(), this.parentSwaps);
        result.swapDepths.putAll(this.swapDepths);
        return result;
    }

    public InternalSchemaSwaps branchAnnotations() {
        HashMap<Key, Value> combined = new HashMap<Key, Value>(this.swaps);
        combined.putAll(this.parentSwaps);
        return new InternalSchemaSwaps(new HashMap<Key, Value>(), this.swapDepths, combined);
    }

    public void registerSwap(Class<?> definitionType, Class<?> originalType, String fieldName, Class<?> targetType, int depth) {
        Value value = new Value(definitionType, originalType, fieldName, targetType, depth);
        Key key = new Key(originalType, fieldName);
        if (this.parentSwaps.containsKey(key)) {
            throw new IllegalArgumentException("Nested SchemaSwap: " + String.valueOf(value));
        }
        if (this.swaps.put(key, value) != null) {
            throw new IllegalArgumentException("Duplicate SchemaSwap: " + String.valueOf(value));
        }
    }

    public SwapResult lookupAndMark(Class<?> originalType, String name) {
        Key key = new Key(originalType, name);
        Value value = this.swaps.getOrDefault(key, this.parentSwaps.get(key));
        if (value != null) {
            int currentDepth = this.swapDepths.getOrDefault(key, 0);
            this.swapDepths.put(key, currentDepth + 1);
            value.markUsed();
            if (currentDepth == value.depth) {
                return new SwapResult(value.getTargetType(), false);
            }
            if (currentDepth > value.depth) {
                throw new IllegalStateException("Somthing has gone wrong with tracking swap depths, please raise an issue.");
            }
            return new SwapResult(null, true);
        }
        return new SwapResult(null, false);
    }

    public void throwIfUnmatchedSwaps() {
        String unmatchedSchemaSwaps = this.swaps.values().stream().filter(value -> !value.used).map(Object::toString).collect(Collectors.joining(", "));
        if (!unmatchedSchemaSwaps.isEmpty()) {
            throw new IllegalArgumentException("Unmatched SchemaSwaps: " + unmatchedSchemaSwaps);
        }
    }

    private static class Value {
        private final Class<?> originalType;
        private final String fieldName;
        private final Class<?> targetType;
        private boolean used;
        private final Class<?> definitionType;
        private final int depth;

        public Value(Class<?> definitionType, Class<?> originalType, String fieldName, Class<?> targetType, int depth) {
            this.definitionType = definitionType;
            this.originalType = originalType;
            this.fieldName = fieldName;
            this.targetType = targetType;
            this.depth = depth;
            this.used = false;
        }

        private void markUsed() {
            this.used = true;
        }

        public Class<?> getTargetType() {
            return this.targetType;
        }

        public String toString() {
            return "@SchemaSwap(originalType=" + this.originalType.getName() + ", fieldName=\"" + this.fieldName + "\", targetType=" + this.targetType.getName() + ") on " + this.definitionType.getName();
        }
    }

    private static final class Key {
        private final Class<?> originalType;
        private final String fieldName;

        public Key(Class<?> originalType, String fieldName) {
            this.originalType = originalType;
            this.fieldName = fieldName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.originalType, key.originalType) && Objects.equals(this.fieldName, key.fieldName);
        }

        public int hashCode() {
            return Objects.hash(this.originalType, this.fieldName);
        }

        public String toString() {
            return new StringJoiner(", ", Key.class.getSimpleName() + "[", "]").add("originalType=" + this.originalType.getName()).add("fieldName='" + this.fieldName + "'").toString();
        }
    }

    static class SwapResult {
        final Class<?> classRef;
        final boolean onGoing;

        public SwapResult(Class<?> classRef, boolean onGoing) {
            this.classRef = classRef;
            this.onGoing = onGoing;
        }
    }
}

