/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GatewayAddress;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GatewayAddressBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GatewayAddressFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GatewayBackendTLS;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GatewayBackendTLSBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GatewayBackendTLSFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GatewayInfrastructure;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GatewayInfrastructureBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GatewayInfrastructureFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GatewaySpec;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.Listener;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.ListenerBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.ListenerFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class GatewaySpecFluent<A extends GatewaySpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<GatewayAddressBuilder> addresses = new ArrayList();
    private GatewayBackendTLSBuilder backendTLS;
    private String gatewayClassName;
    private GatewayInfrastructureBuilder infrastructure;
    private ArrayList<ListenerBuilder> listeners = new ArrayList();
    private Map<String, Object> additionalProperties;

    public GatewaySpecFluent() {
    }

    public GatewaySpecFluent(GatewaySpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(GatewaySpec instance) {
        GatewaySpec gatewaySpec = instance = instance != null ? instance : new GatewaySpec();
        if (instance != null) {
            this.withAddresses(instance.getAddresses());
            this.withBackendTLS(instance.getBackendTLS());
            this.withGatewayClassName(instance.getGatewayClassName());
            this.withInfrastructure(instance.getInfrastructure());
            this.withListeners(instance.getListeners());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAddresses(int index, GatewayAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        GatewayAddressBuilder builder = new GatewayAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get("addresses").add(builder);
            this.addresses.add(index, builder);
        }
        return (A)this;
    }

    public A setToAddresses(int index, GatewayAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        GatewayAddressBuilder builder = new GatewayAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get("addresses").add(builder);
            this.addresses.set(index, builder);
        }
        return (A)this;
    }

    public A addToAddresses(GatewayAddress ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (GatewayAddress item : items) {
            GatewayAddressBuilder builder = new GatewayAddressBuilder(item);
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    public A addAllToAddresses(Collection<GatewayAddress> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (GatewayAddress item : items) {
            GatewayAddressBuilder builder = new GatewayAddressBuilder(item);
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    public A removeFromAddresses(GatewayAddress ... items) {
        if (this.addresses == null) {
            return (A)this;
        }
        for (GatewayAddress item : items) {
            GatewayAddressBuilder builder = new GatewayAddressBuilder(item);
            this._visitables.get("addresses").remove(builder);
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromAddresses(Collection<GatewayAddress> items) {
        if (this.addresses == null) {
            return (A)this;
        }
        for (GatewayAddress item : items) {
            GatewayAddressBuilder builder = new GatewayAddressBuilder(item);
            this._visitables.get("addresses").remove(builder);
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromAddresses(Predicate<GatewayAddressBuilder> predicate) {
        if (this.addresses == null) {
            return (A)this;
        }
        Iterator<GatewayAddressBuilder> each = this.addresses.iterator();
        Object visitables = this._visitables.get("addresses");
        while (each.hasNext()) {
            GatewayAddressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<GatewayAddress> buildAddresses() {
        return this.addresses != null ? GatewaySpecFluent.build(this.addresses) : null;
    }

    public GatewayAddress buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    public GatewayAddress buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    public GatewayAddress buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    public GatewayAddress buildMatchingAddress(Predicate<GatewayAddressBuilder> predicate) {
        for (GatewayAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAddress(Predicate<GatewayAddressBuilder> predicate) {
        for (GatewayAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAddresses(List<GatewayAddress> addresses) {
        if (this.addresses != null) {
            this._visitables.get("addresses").clear();
        }
        if (addresses != null) {
            this.addresses = new ArrayList();
            for (GatewayAddress item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)this;
    }

    public A withAddresses(GatewayAddress ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
            this._visitables.remove("addresses");
        }
        if (addresses != null) {
            for (GatewayAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)this;
    }

    public boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    public A addNewAddress(String type, String value) {
        return this.addToAddresses(new GatewayAddress(type, value));
    }

    public AddressesNested<A> addNewAddress() {
        return new AddressesNested(-1, null);
    }

    public AddressesNested<A> addNewAddressLike(GatewayAddress item) {
        return new AddressesNested(-1, item);
    }

    public AddressesNested<A> setNewAddressLike(int index, GatewayAddress item) {
        return new AddressesNested(index, item);
    }

    public AddressesNested<A> editAddress(int index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException("Can't edit addresses. Index exceeds size.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException("Can't edit first addresses. The list is empty.");
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    public AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last addresses. The list is empty.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public AddressesNested<A> editMatchingAddress(Predicate<GatewayAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.test(this.addresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching addresses. No match found.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public GatewayBackendTLS buildBackendTLS() {
        return this.backendTLS != null ? this.backendTLS.build() : null;
    }

    public A withBackendTLS(GatewayBackendTLS backendTLS) {
        this._visitables.remove("backendTLS");
        if (backendTLS != null) {
            this.backendTLS = new GatewayBackendTLSBuilder(backendTLS);
            this._visitables.get("backendTLS").add(this.backendTLS);
        } else {
            this.backendTLS = null;
            this._visitables.get("backendTLS").remove(this.backendTLS);
        }
        return (A)this;
    }

    public boolean hasBackendTLS() {
        return this.backendTLS != null;
    }

    public BackendTLSNested<A> withNewBackendTLS() {
        return new BackendTLSNested(null);
    }

    public BackendTLSNested<A> withNewBackendTLSLike(GatewayBackendTLS item) {
        return new BackendTLSNested(item);
    }

    public BackendTLSNested<A> editBackendTLS() {
        return this.withNewBackendTLSLike(Optional.ofNullable(this.buildBackendTLS()).orElse(null));
    }

    public BackendTLSNested<A> editOrNewBackendTLS() {
        return this.withNewBackendTLSLike(Optional.ofNullable(this.buildBackendTLS()).orElse(new GatewayBackendTLSBuilder().build()));
    }

    public BackendTLSNested<A> editOrNewBackendTLSLike(GatewayBackendTLS item) {
        return this.withNewBackendTLSLike(Optional.ofNullable(this.buildBackendTLS()).orElse(item));
    }

    public String getGatewayClassName() {
        return this.gatewayClassName;
    }

    public A withGatewayClassName(String gatewayClassName) {
        this.gatewayClassName = gatewayClassName;
        return (A)this;
    }

    public boolean hasGatewayClassName() {
        return this.gatewayClassName != null;
    }

    public GatewayInfrastructure buildInfrastructure() {
        return this.infrastructure != null ? this.infrastructure.build() : null;
    }

    public A withInfrastructure(GatewayInfrastructure infrastructure) {
        this._visitables.remove("infrastructure");
        if (infrastructure != null) {
            this.infrastructure = new GatewayInfrastructureBuilder(infrastructure);
            this._visitables.get("infrastructure").add(this.infrastructure);
        } else {
            this.infrastructure = null;
            this._visitables.get("infrastructure").remove(this.infrastructure);
        }
        return (A)this;
    }

    public boolean hasInfrastructure() {
        return this.infrastructure != null;
    }

    public InfrastructureNested<A> withNewInfrastructure() {
        return new InfrastructureNested(null);
    }

    public InfrastructureNested<A> withNewInfrastructureLike(GatewayInfrastructure item) {
        return new InfrastructureNested(item);
    }

    public InfrastructureNested<A> editInfrastructure() {
        return this.withNewInfrastructureLike(Optional.ofNullable(this.buildInfrastructure()).orElse(null));
    }

    public InfrastructureNested<A> editOrNewInfrastructure() {
        return this.withNewInfrastructureLike(Optional.ofNullable(this.buildInfrastructure()).orElse(new GatewayInfrastructureBuilder().build()));
    }

    public InfrastructureNested<A> editOrNewInfrastructureLike(GatewayInfrastructure item) {
        return this.withNewInfrastructureLike(Optional.ofNullable(this.buildInfrastructure()).orElse(item));
    }

    public A addToListeners(int index, Listener item) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        ListenerBuilder builder = new ListenerBuilder(item);
        if (index < 0 || index >= this.listeners.size()) {
            this._visitables.get("listeners").add(builder);
            this.listeners.add(builder);
        } else {
            this._visitables.get("listeners").add(builder);
            this.listeners.add(index, builder);
        }
        return (A)this;
    }

    public A setToListeners(int index, Listener item) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        ListenerBuilder builder = new ListenerBuilder(item);
        if (index < 0 || index >= this.listeners.size()) {
            this._visitables.get("listeners").add(builder);
            this.listeners.add(builder);
        } else {
            this._visitables.get("listeners").add(builder);
            this.listeners.set(index, builder);
        }
        return (A)this;
    }

    public A addToListeners(Listener ... items) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        for (Listener item : items) {
            ListenerBuilder builder = new ListenerBuilder(item);
            this._visitables.get("listeners").add(builder);
            this.listeners.add(builder);
        }
        return (A)this;
    }

    public A addAllToListeners(Collection<Listener> items) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        for (Listener item : items) {
            ListenerBuilder builder = new ListenerBuilder(item);
            this._visitables.get("listeners").add(builder);
            this.listeners.add(builder);
        }
        return (A)this;
    }

    public A removeFromListeners(Listener ... items) {
        if (this.listeners == null) {
            return (A)this;
        }
        for (Listener item : items) {
            ListenerBuilder builder = new ListenerBuilder(item);
            this._visitables.get("listeners").remove(builder);
            this.listeners.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromListeners(Collection<Listener> items) {
        if (this.listeners == null) {
            return (A)this;
        }
        for (Listener item : items) {
            ListenerBuilder builder = new ListenerBuilder(item);
            this._visitables.get("listeners").remove(builder);
            this.listeners.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromListeners(Predicate<ListenerBuilder> predicate) {
        if (this.listeners == null) {
            return (A)this;
        }
        Iterator<ListenerBuilder> each = this.listeners.iterator();
        Object visitables = this._visitables.get("listeners");
        while (each.hasNext()) {
            ListenerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Listener> buildListeners() {
        return this.listeners != null ? GatewaySpecFluent.build(this.listeners) : null;
    }

    public Listener buildListener(int index) {
        return this.listeners.get(index).build();
    }

    public Listener buildFirstListener() {
        return this.listeners.get(0).build();
    }

    public Listener buildLastListener() {
        return this.listeners.get(this.listeners.size() - 1).build();
    }

    public Listener buildMatchingListener(Predicate<ListenerBuilder> predicate) {
        for (ListenerBuilder item : this.listeners) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingListener(Predicate<ListenerBuilder> predicate) {
        for (ListenerBuilder item : this.listeners) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withListeners(List<Listener> listeners) {
        if (this.listeners != null) {
            this._visitables.get("listeners").clear();
        }
        if (listeners != null) {
            this.listeners = new ArrayList();
            for (Listener item : listeners) {
                this.addToListeners(item);
            }
        } else {
            this.listeners = null;
        }
        return (A)this;
    }

    public A withListeners(Listener ... listeners) {
        if (this.listeners != null) {
            this.listeners.clear();
            this._visitables.remove("listeners");
        }
        if (listeners != null) {
            for (Listener item : listeners) {
                this.addToListeners(item);
            }
        }
        return (A)this;
    }

    public boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    public ListenersNested<A> addNewListener() {
        return new ListenersNested(-1, null);
    }

    public ListenersNested<A> addNewListenerLike(Listener item) {
        return new ListenersNested(-1, item);
    }

    public ListenersNested<A> setNewListenerLike(int index, Listener item) {
        return new ListenersNested(index, item);
    }

    public ListenersNested<A> editListener(int index) {
        if (this.listeners.size() <= index) {
            throw new RuntimeException("Can't edit listeners. Index exceeds size.");
        }
        return this.setNewListenerLike(index, this.buildListener(index));
    }

    public ListenersNested<A> editFirstListener() {
        if (this.listeners.size() == 0) {
            throw new RuntimeException("Can't edit first listeners. The list is empty.");
        }
        return this.setNewListenerLike(0, this.buildListener(0));
    }

    public ListenersNested<A> editLastListener() {
        int index = this.listeners.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last listeners. The list is empty.");
        }
        return this.setNewListenerLike(index, this.buildListener(index));
    }

    public ListenersNested<A> editMatchingListener(Predicate<ListenerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (!predicate.test(this.listeners.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching listeners. No match found.");
        }
        return this.setNewListenerLike(index, this.buildListener(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GatewaySpecFluent that = (GatewaySpecFluent)o;
        if (!Objects.equals(this.addresses, that.addresses)) {
            return false;
        }
        if (!Objects.equals(this.backendTLS, that.backendTLS)) {
            return false;
        }
        if (!Objects.equals(this.gatewayClassName, that.gatewayClassName)) {
            return false;
        }
        if (!Objects.equals(this.infrastructure, that.infrastructure)) {
            return false;
        }
        if (!Objects.equals(this.listeners, that.listeners)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.addresses, this.backendTLS, this.gatewayClassName, this.infrastructure, this.listeners, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(String.valueOf(this.addresses) + ",");
        }
        if (this.backendTLS != null) {
            sb.append("backendTLS:");
            sb.append(String.valueOf(this.backendTLS) + ",");
        }
        if (this.gatewayClassName != null) {
            sb.append("gatewayClassName:");
            sb.append(this.gatewayClassName + ",");
        }
        if (this.infrastructure != null) {
            sb.append("infrastructure:");
            sb.append(String.valueOf(this.infrastructure) + ",");
        }
        if (this.listeners != null && !this.listeners.isEmpty()) {
            sb.append("listeners:");
            sb.append(String.valueOf(this.listeners) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ListenersNested<N>
    extends ListenerFluent<ListenersNested<N>>
    implements Nested<N> {
        ListenerBuilder builder;
        int index;

        ListenersNested(int index, Listener item) {
            this.index = index;
            this.builder = new ListenerBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)GatewaySpecFluent.this.setToListeners(this.index, this.builder.build());
        }

        public N endListener() {
            return this.and();
        }
    }

    public class InfrastructureNested<N>
    extends GatewayInfrastructureFluent<InfrastructureNested<N>>
    implements Nested<N> {
        GatewayInfrastructureBuilder builder;

        InfrastructureNested(GatewayInfrastructure item) {
            this.builder = new GatewayInfrastructureBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)GatewaySpecFluent.this.withInfrastructure(this.builder.build());
        }

        public N endInfrastructure() {
            return this.and();
        }
    }

    public class BackendTLSNested<N>
    extends GatewayBackendTLSFluent<BackendTLSNested<N>>
    implements Nested<N> {
        GatewayBackendTLSBuilder builder;

        BackendTLSNested(GatewayBackendTLS item) {
            this.builder = new GatewayBackendTLSBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)GatewaySpecFluent.this.withBackendTLS(this.builder.build());
        }

        public N endBackendTLS() {
            return this.and();
        }
    }

    public class AddressesNested<N>
    extends GatewayAddressFluent<AddressesNested<N>>
    implements Nested<N> {
        GatewayAddressBuilder builder;
        int index;

        AddressesNested(int index, GatewayAddress item) {
            this.index = index;
            this.builder = new GatewayAddressBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)GatewaySpecFluent.this.setToAddresses(this.index, this.builder.build());
        }

        public N endAddress() {
            return this.and();
        }
    }
}

