/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ContainerUser;
import io.fabric8.kubernetes.api.model.LinuxContainerUser;
import io.fabric8.kubernetes.api.model.LinuxContainerUserBuilder;
import io.fabric8.kubernetes.api.model.LinuxContainerUserFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ContainerUserFluent<A extends ContainerUserFluent<A>>
extends BaseFluent<A> {
    private LinuxContainerUserBuilder linux;
    private Map<String, Object> additionalProperties;

    public ContainerUserFluent() {
    }

    public ContainerUserFluent(ContainerUser instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ContainerUser instance) {
        ContainerUser containerUser = instance = instance != null ? instance : new ContainerUser();
        if (instance != null) {
            this.withLinux(instance.getLinux());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public LinuxContainerUser buildLinux() {
        return this.linux != null ? this.linux.build() : null;
    }

    public A withLinux(LinuxContainerUser linux) {
        this._visitables.remove("linux");
        if (linux != null) {
            this.linux = new LinuxContainerUserBuilder(linux);
            this._visitables.get("linux").add(this.linux);
        } else {
            this.linux = null;
            this._visitables.get("linux").remove(this.linux);
        }
        return (A)this;
    }

    public boolean hasLinux() {
        return this.linux != null;
    }

    public LinuxNested<A> withNewLinux() {
        return new LinuxNested(null);
    }

    public LinuxNested<A> withNewLinuxLike(LinuxContainerUser item) {
        return new LinuxNested(item);
    }

    public LinuxNested<A> editLinux() {
        return this.withNewLinuxLike(Optional.ofNullable(this.buildLinux()).orElse(null));
    }

    public LinuxNested<A> editOrNewLinux() {
        return this.withNewLinuxLike(Optional.ofNullable(this.buildLinux()).orElse(new LinuxContainerUserBuilder().build()));
    }

    public LinuxNested<A> editOrNewLinuxLike(LinuxContainerUser item) {
        return this.withNewLinuxLike(Optional.ofNullable(this.buildLinux()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerUserFluent that = (ContainerUserFluent)o;
        if (!Objects.equals(this.linux, that.linux)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.linux, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.linux != null) {
            sb.append("linux:");
            sb.append(this.linux + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class LinuxNested<N>
    extends LinuxContainerUserFluent<LinuxNested<N>>
    implements Nested<N> {
        LinuxContainerUserBuilder builder;

        LinuxNested(LinuxContainerUser item) {
            this.builder = new LinuxContainerUserBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ContainerUserFluent.this.withLinux(this.builder.build());
        }

        public N endLinux() {
            return this.and();
        }
    }
}

