/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator.collector;

import io.fabric8.crd.generator.collector.JandexException;
import io.fabric8.crd.generator.collector.JandexIndexer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.UnsupportedVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JandexUtils {
    private static final Logger log = LoggerFactory.getLogger(JandexUtils.class);
    static final String JAR_FILE_SUFFIX = ".jar";
    private static final String DEFAULT_JANDEX_INDEX = "META-INF/jandex.idx";

    private JandexUtils() {
    }

    static IndexView createIndex(Collection<IndexView> indices, Collection<File> filesToScan, boolean forceIndex) {
        LinkedList<IndexView> allIndices = new LinkedList<IndexView>(indices);
        if (!filesToScan.isEmpty()) {
            HashSet<File> actualFilesToScan = new HashSet<File>();
            for (File file : filesToScan) {
                if (forceIndex) {
                    actualFilesToScan.add(file);
                    continue;
                }
                Optional<Index> index = JandexUtils.findIndex(file);
                if (index.isPresent()) {
                    log.trace("Found existing index for {}", (Object)file);
                    allIndices.add(index.get());
                    continue;
                }
                actualFilesToScan.add(file);
            }
            if (!actualFilesToScan.isEmpty()) {
                log.debug("Creating {} indices", (Object)actualFilesToScan.size());
                allIndices.add(JandexUtils.createIndex(actualFilesToScan));
            }
        }
        log.trace("Using {} indices", (Object)allIndices.size());
        return CompositeIndex.create(allIndices);
    }

    static Index createIndex(Collection<File> files) {
        return new JandexIndexer().createIndex(files);
    }

    static Optional<Index> findIndex(File file) {
        return JandexUtils.findIndexInDirectory(file).map(Optional::of).orElseGet(() -> JandexUtils.findIndexInJarFile(file));
    }

    static Optional<Index> findIndexInDirectory(File file) {
        Optional<Index> optional;
        block10: {
            if (!file.isDirectory()) {
                return Optional.empty();
            }
            File jandexIndexFile = new File(file, DEFAULT_JANDEX_INDEX);
            if (!jandexIndexFile.exists()) {
                return Optional.empty();
            }
            InputStream in = Files.newInputStream(jandexIndexFile.toPath(), new OpenOption[0]);
            try {
                optional = Optional.of(JandexUtils.readIndex(in));
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new JandexException("Could not read Jandex index from directory: " + file, e);
                }
            }
            in.close();
        }
        return optional;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Optional<Index> findIndexInJarFile(File file) {
        if (!file.isFile()) return Optional.empty();
        if (!file.getName().endsWith(JAR_FILE_SUFFIX)) {
            return Optional.empty();
        }
        try (JarFile zip = new JarFile(file);){
            JarEntry entry = zip.getJarEntry(DEFAULT_JANDEX_INDEX);
            if (entry == null) {
                Optional<Index> optional = Optional.empty();
                return optional;
            }
            Optional<Index> optional = Optional.of(JandexUtils.readIndex(zip.getInputStream(entry)));
            return optional;
        }
        catch (IOException | IllegalArgumentException | UnsupportedVersion e) {
            throw new JandexException("Could not read Jandex index from JAR file " + file, e);
        }
    }

    private static Index readIndex(InputStream in) throws IOException {
        IndexReader reader = new IndexReader(in);
        return reader.read();
    }
}

