/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crdv2.generator;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.JsonSchemaGenerator;
import com.fasterxml.jackson.module.jsonSchema.factories.JsonSchemaFactory;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.fasterxml.jackson.module.jsonSchema.factories.VisitorContext;
import com.fasterxml.jackson.module.jsonSchema.factories.WrapperFactory;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import io.fabric8.kubernetes.client.utils.KubernetesSerialization;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ResolvingContext {
    final JsonSchemaGenerator generator;
    final ObjectMapper objectMapper;
    final KubernetesSerialization kubernetesSerialization;
    final Map<String, GeneratorObjectSchema> uriToJacksonSchema;
    final boolean implicitPreserveUnknownFields;
    private static KubernetesSerialization KUBERNETES_SERIALIZATION;
    private static ObjectMapper OBJECT_MAPPER;

    public static ResolvingContext defaultResolvingContext(boolean implicitPreserveUnknownFields) {
        if (KUBERNETES_SERIALIZATION == null) {
            OBJECT_MAPPER = new ObjectMapper();
            KUBERNETES_SERIALIZATION = new KubernetesSerialization(OBJECT_MAPPER, false);
        }
        return new ResolvingContext(OBJECT_MAPPER, KUBERNETES_SERIALIZATION, implicitPreserveUnknownFields);
    }

    public ResolvingContext forkContext() {
        return new ResolvingContext(this.objectMapper, this.kubernetesSerialization, this.uriToJacksonSchema, this.implicitPreserveUnknownFields);
    }

    public ResolvingContext(ObjectMapper mapper, KubernetesSerialization kubernetesSerialization, boolean implicitPreserveUnknownFields) {
        this(mapper, kubernetesSerialization, new ConcurrentHashMap<String, GeneratorObjectSchema>(), implicitPreserveUnknownFields);
    }

    private ResolvingContext(ObjectMapper mapper, KubernetesSerialization kubernetesSerialization, Map<String, GeneratorObjectSchema> uriToJacksonSchema, boolean implicitPreserveUnknownFields) {
        this.uriToJacksonSchema = uriToJacksonSchema;
        this.objectMapper = mapper;
        this.kubernetesSerialization = kubernetesSerialization;
        this.implicitPreserveUnknownFields = implicitPreserveUnknownFields;
        this.generator = new JsonSchemaGenerator(mapper, new WrapperFactory(){

            @Override
            public SchemaFactoryWrapper getWrapper(SerializerProvider provider) {
                return new KubernetesSchemaFactoryWrapper(provider, this);
            }

            @Override
            public SchemaFactoryWrapper getWrapper(SerializerProvider provider, VisitorContext rvc) {
                SchemaFactoryWrapper wrapper = this.getWrapper(provider);
                wrapper.setVisitorContext(rvc);
                return wrapper;
            }
        });
    }

    JsonSchema toJsonSchema(Class<?> clazz) {
        try {
            return this.generator.generateSchema(clazz);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
    }

    private final class KubernetesSchemaFactoryWrapper
    extends SchemaFactoryWrapper {
        private KubernetesSchemaFactoryWrapper(SerializerProvider p, WrapperFactory wrapperFactory) {
            super(p, wrapperFactory);
            this.schemaProvider = new JsonSchemaFactory(){

                @Override
                public ObjectSchema objectSchema() {
                    return new GeneratorObjectSchema();
                }
            };
        }

        @Override
        public JsonObjectFormatVisitor expectObjectFormat(JavaType convertedType) {
            JsonObjectFormatVisitor result = super.expectObjectFormat(convertedType);
            ((GeneratorObjectSchema)this.schema).javaType = convertedType;
            ResolvingContext.this.uriToJacksonSchema.putIfAbsent(this.visitorContext.getSeenSchemaUri(convertedType), (GeneratorObjectSchema)this.schema);
            return result;
        }
    }

    static final class GeneratorObjectSchema
    extends ObjectSchema {
        JavaType javaType;
        Map<String, BeanProperty> beanProperties = new LinkedHashMap<String, BeanProperty>();

        GeneratorObjectSchema() {
        }

        @Override
        public void putOptionalProperty(BeanProperty property, JsonSchema jsonSchema) {
            this.beanProperties.put(property.getName(), property);
            super.putOptionalProperty(property, jsonSchema);
        }

        @Override
        public JsonSchema putProperty(BeanProperty property, JsonSchema value) {
            this.beanProperties.put(property.getName(), property);
            return super.putProperty(property, value);
        }
    }
}

