/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator.cli;

import io.fabric8.crd.generator.cli.CRDGeneratorCliException;
import io.fabric8.crd.generator.cli.CRDGeneratorExecutionExceptionHandler;
import io.fabric8.crd.generator.cli.CustomResourceClassNotFoundException;
import io.fabric8.crd.generator.cli.KubernetesClientVersionProvider;
import io.fabric8.crd.generator.cli.LoggingConfiguration;
import io.fabric8.crd.generator.cli.SourceParameter;
import io.fabric8.crd.generator.cli.SourceParameterTypeConverter;
import io.fabric8.crd.generator.collector.CustomResourceCollector;
import io.fabric8.crdv2.generator.CRDGenerationInfo;
import io.fabric8.crdv2.generator.CRDGenerator;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="crd-gen", description={"@|bold Fabric8 CRD-Generator|@%nGenerate Custom Resource Definitions (CRD) for Kubernetes from Java classes."}, exitCodeList={" 0:Successful execution", " 1:Unexpected error", " 2:Invalid input", "70:Custom Resource class loading failed", "80:No Custom Resource classes retained after filtering"}, helpCommand=true, mixinStandardHelpOptions=true, usageHelpAutoWidth=true, sortOptions=false, versionProvider=KubernetesClientVersionProvider.class, synopsisHeading="%nUsage:%n%n", descriptionHeading="%nDescription:%n%n", parameterListHeading="%nParameters:%n", optionListHeading="%nOptions:%n", exitCodeListHeading="%nExit Codes:%n", footerHeading="%nExamples:%n", footer={"  Generate CRDs for Custom Resource classes in a directory:%n    @|faint ${COMMAND-NAME} target/classes/|@%n  Generate CRDs for Custom Resource classes in a JAR file:%n    @|faint ${COMMAND-NAME} my-jar-with-custom-resources.jar|@%n  Generate CRD by using a single class only:%n    @|faint ${COMMAND-NAME} -cp target/classes/ com.example.MyCustomResource|@"})
public class CRDGeneratorCLI
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(CRDGeneratorCLI.class);
    private static final CRDGenerationInfo EMPTY_INFO = new CRDGenerationInfo();
    private CRDGenerationInfo crdGenerationInfo = EMPTY_INFO;
    private final Set<String> customResourceClassNames = new HashSet<String>();
    private final Set<File> filesToScan = new HashSet<File>();
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"-o", "--output-dir"}, description={"The output directory where the CRDs are emitted."}, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    File outputDirectory = new File(".");
    @CommandLine.Option(names={"-cp", "--classpath"}, paramLabel="<classpathElement>", description={"Additional classpath element, e.g. a dependency packaged as JAR file or a directory of class files."})
    List<String> classpathElements = new ArrayList<String>();
    @CommandLine.Option(names={"--force-index"}, description={"Create Jandex index even if the directory or JAR file contains an existing index."}, defaultValue="false")
    Boolean forceIndex;
    @CommandLine.Option(names={"--force-scan"}, description={"Scan directories and JAR files even if Custom Resource classes are given."}, defaultValue="false")
    Boolean forceScan;
    @CommandLine.Option(names={"--no-parallel"}, description={"Disable parallel generation of CRDs."}, defaultValue="false")
    Boolean parallelDisabled;
    @CommandLine.Option(names={"--implicit-preserve-unknown-fields"}, description={"`x-kubernetes-preserve-unknown-fields: true` will be added on objects which contain an any-setter or any-getter."}, defaultValue="false")
    Boolean implicitPreserveUnknownFields;
    @CommandLine.Option(names={"--include-package"}, paramLabel="<package>", description={"Filter Custom Resource classes after scanning by package inclusions."})
    List<String> includedPackages = new LinkedList<String>();
    @CommandLine.Option(names={"--exclude-package"}, paramLabel="<package>", description={"Filter Custom Resource classes after scanning by package exclusions."})
    List<String> excludedPackages = new LinkedList<String>();
    @CommandLine.Option(names={"-v"}, description={"Verbose mode. Helpful for troubleshooting.\nMultiple -v options increase the verbosity."})
    List<Boolean> verbose = new LinkedList<Boolean>();

    @CommandLine.Parameters(paramLabel="<source>", arity="1..*", converter={SourceParameterTypeConverter.class}, description={"A directory or JAR file to scan for Custom Resource classes, or a full qualified Custom Resource class name."})
    void setParameters(List<SourceParameter> parameters) {
        this.setCustomResourceClassNames(parameters);
        this.setFilesToScan(parameters);
    }

    @Override
    public void run() {
        File sanitizedOutputDirectory;
        LoggingConfiguration.configureLogger(this.verbose);
        List<String> allClasspathElements = this.getClasspathElements();
        log.trace("Custom Resource Class Names: {}", (Object)this.customResourceClassNames);
        log.trace("Files to scan: {}", (Object)this.filesToScan);
        log.trace("Classpath: {}", (Object)allClasspathElements);
        CustomResourceCollector customResourceCollector = new CustomResourceCollector().withClasspathElements(allClasspathElements).withFilesToScan(this.filesToScan).withForceIndex(this.forceIndex).withForceScan(this.forceScan).withCustomResourceClasses(this.customResourceClassNames).withIncludePackages(this.includedPackages).withExcludePackages(this.excludedPackages);
        List<Class<? extends HasMetadata>> customResourceClasses = customResourceCollector.findCustomResourceClasses();
        if (customResourceClasses.isEmpty()) {
            throw new CustomResourceClassNotFoundException();
        }
        log.debug("Generating CRDs for {} Custom Resource classes", (Object)customResourceClasses.size());
        try {
            sanitizedOutputDirectory = this.outputDirectory.getCanonicalFile();
        }
        catch (IOException e) {
            throw new CRDGeneratorCliException("Could not get canonical file for " + this.outputDirectory, e);
        }
        try {
            Files.createDirectories(sanitizedOutputDirectory.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new CRDGeneratorCliException("Could not create output directory at " + sanitizedOutputDirectory, e);
        }
        CRDGenerator crdGenerator = new CRDGenerator().customResourceClasses(customResourceClasses).withParallelGenerationEnabled(this.parallelDisabled == false).withImplicitPreserveUnknownFields(this.implicitPreserveUnknownFields).inOutputDir(sanitizedOutputDirectory);
        this.crdGenerationInfo = crdGenerator.detailedGenerate();
        this.crdGenerationInfo.getCRDDetailsPerNameAndVersion().forEach((crdName, versionToInfo) -> {
            this.getOut().printf("Generated CRD %s:%n", crdName);
            versionToInfo.forEach((version, info) -> this.getOut().printf(" %s -> %s%n", version, info.getFilePath()));
        });
    }

    CRDGenerationInfo getCrdGenerationInfo() {
        return this.crdGenerationInfo;
    }

    String getDebugText() {
        String lineSeparator = System.lineSeparator();
        StringBuilder sb = new StringBuilder();
        sb.append(lineSeparator);
        if (!this.customResourceClassNames.isEmpty()) {
            sb.append("Custom Resource class names:");
            sb.append(lineSeparator);
            this.customResourceClassNames.forEach(fqcn -> sb.append(" ").append((String)fqcn).append(lineSeparator));
            sb.append(lineSeparator);
        }
        if (this.filesToScan.isEmpty()) {
            sb.append("Scan Paths: []");
            sb.append(lineSeparator);
        } else {
            sb.append("Scan Paths:");
            sb.append(lineSeparator);
            this.filesToScan.forEach(f -> sb.append(" ").append(f.getPath()).append(lineSeparator));
            sb.append(lineSeparator);
        }
        List<String> allClasspathElements = this.getClasspathElements();
        if (allClasspathElements.isEmpty()) {
            sb.append("Classpath: []");
            sb.append(lineSeparator);
        } else {
            sb.append("Classpath:");
            sb.append(lineSeparator);
            allClasspathElements.forEach(cpe -> sb.append(" ").append((String)cpe).append(lineSeparator));
            sb.append(lineSeparator);
        }
        sb.append(lineSeparator);
        return sb.toString();
    }

    private void setCustomResourceClassNames(List<SourceParameter> source) {
        source.stream().filter(s -> s instanceof SourceParameter.CustomResourceClass).map(SourceParameter.CustomResourceClass.class::cast).map(SourceParameter.CustomResourceClass::getValue).forEach(this.customResourceClassNames::add);
    }

    private void setFilesToScan(List<SourceParameter> source) {
        source.stream().filter(s -> s instanceof SourceParameter.FileToScan).map(SourceParameter.FileToScan.class::cast).map(SourceParameter.FileToScan::getValue).forEach(this.filesToScan::add);
    }

    private List<String> getClasspathElements() {
        LinkedList<String> allClasspathElements = new LinkedList<String>(this.classpathElements);
        this.filesToScan.stream().map(File::getPath).forEach(allClasspathElements::add);
        return allClasspathElements;
    }

    private PrintWriter getOut() {
        return this.spec.commandLine().getOut();
    }

    public static void main(String[] args) {
        System.exit(CRDGeneratorCLI.exec(args));
    }

    public static int exec(String[] args) {
        return CRDGeneratorCLI.createCommandLine().execute(args);
    }

    static CommandLine createCommandLine() {
        return CRDGeneratorCLI.createCommandLine(new CRDGeneratorCLI());
    }

    static CommandLine createCommandLine(CRDGeneratorCLI crdGeneratorCLI) {
        return new CommandLine(crdGeneratorCLI).setExecutionExceptionHandler(new CRDGeneratorExecutionExceptionHandler(crdGeneratorCLI::getDebugText));
    }
}

