/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.examples.ctl;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.examples.ctl.CommandGet;
import io.etcd.jetcd.examples.ctl.CommandPut;
import io.etcd.jetcd.examples.ctl.CommandWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        Args global = new Args();
        CommandGet getCmd = new CommandGet();
        CommandPut putCmd = new CommandPut();
        CommandWatch watchCmd = new CommandWatch();
        JCommander jc = JCommander.newBuilder().addObject(global).addCommand("get", getCmd, new String[0]).addCommand("put", putCmd, new String[0]).addCommand("watch", watchCmd, new String[0]).build();
        jc.parse(args);
        String cmd = jc.getParsedCommand();
        if (cmd == null || global.help) {
            jc.usage();
            return;
        }
        try (Client client = Client.builder().endpoints(global.endpoints.split(",")).build();){
            switch (cmd) {
                case "get": {
                    getCmd.accept(client);
                    return;
                }
                case "put": {
                    putCmd.accept(client);
                    return;
                }
                case "watch": {
                    watchCmd.accept(client);
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            LOGGER.error(cmd + " Error {}", e);
            System.exit(1);
        }
    }

    public static class Args {
        @Parameter(names={"--endpoints"}, description="gRPC endpoints ")
        private String endpoints = "http://127.0.0.1:2379";
        @Parameter(names={"-h", "--help"}, help=true)
        private boolean help = false;
    }
}

