/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.examples.ctl;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Charsets;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.options.WatchOption;
import io.etcd.jetcd.watch.WatchEvent;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import org.jooq.lambda.fi.util.function.CheckedConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parameters(separators="=", commandDescription="Watches events stream for a key")
class CommandWatch
implements CheckedConsumer<Client> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandWatch.class);
    @Parameter(arity=1, description="<key>")
    String key;
    @Parameter(names={"--rev"}, description="Revision to start watching")
    Long rev = 0L;
    @Parameter(names={"-m", "--max-events"}, description="the maximum number of events to receive")
    Integer maxEvents = Integer.MAX_VALUE;

    CommandWatch() {
    }

    public void accept(Client client) throws Exception {
        CountDownLatch latch = new CountDownLatch(this.maxEvents);
        Watch.Watcher watcher = null;
        try {
            ByteSequence watchKey = ByteSequence.from((String)this.key, (Charset)Charsets.UTF_8);
            WatchOption watchOpts = WatchOption.newBuilder().withRevision(this.rev.longValue()).build();
            watcher = client.getWatchClient().watch(watchKey, watchOpts, response -> {
                for (WatchEvent event : response.getEvents()) {
                    LOGGER.info("type={}, key={}, value={}", new Object[]{event.getEventType().toString(), Optional.ofNullable(event.getKeyValue().getKey()).map(bs -> bs.toString(Charsets.UTF_8)).orElse(""), Optional.ofNullable(event.getKeyValue().getValue()).map(bs -> bs.toString(Charsets.UTF_8)).orElse("")});
                }
                latch.countDown();
            });
            latch.await();
        }
        catch (Exception e) {
            if (watcher != null) {
                watcher.close();
            }
            throw e;
        }
    }
}

