/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd;

import io.etcd.jetcd.Auth;
import io.etcd.jetcd.AuthImpl;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.ClientBuilder;
import io.etcd.jetcd.ClientConnectionManager;
import io.etcd.jetcd.Cluster;
import io.etcd.jetcd.ClusterImpl;
import io.etcd.jetcd.Election;
import io.etcd.jetcd.ElectionImpl;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.KVImpl;
import io.etcd.jetcd.Lease;
import io.etcd.jetcd.LeaseImpl;
import io.etcd.jetcd.Lock;
import io.etcd.jetcd.LockImpl;
import io.etcd.jetcd.Maintenance;
import io.etcd.jetcd.MaintenanceImpl;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.WatchImpl;
import io.etcd.jetcd.support.MemoizingClientSupplier;

final class ClientImpl
implements Client {
    private final ClientConnectionManager connectionManager;
    private final MemoizingClientSupplier<KV> kvClient;
    private final MemoizingClientSupplier<Auth> authClient;
    private final MemoizingClientSupplier<Maintenance> maintenanceClient;
    private final MemoizingClientSupplier<Cluster> clusterClient;
    private final MemoizingClientSupplier<Lease> leaseClient;
    private final MemoizingClientSupplier<Watch> watchClient;
    private final MemoizingClientSupplier<Lock> lockClient;
    private final MemoizingClientSupplier<Election> electionClient;

    public ClientImpl(ClientBuilder clientBuilder) {
        this.connectionManager = new ClientConnectionManager(clientBuilder.copy());
        if (!clientBuilder.lazyInitialization()) {
            this.connectionManager.getChannel();
        }
        this.kvClient = new MemoizingClientSupplier<KV>(() -> new KVImpl(this.connectionManager));
        this.authClient = new MemoizingClientSupplier<Auth>(() -> new AuthImpl(this.connectionManager));
        this.maintenanceClient = new MemoizingClientSupplier<Maintenance>(() -> new MaintenanceImpl(this.connectionManager));
        this.clusterClient = new MemoizingClientSupplier<Cluster>(() -> new ClusterImpl(this.connectionManager));
        this.leaseClient = new MemoizingClientSupplier<Lease>(() -> new LeaseImpl(this.connectionManager));
        this.watchClient = new MemoizingClientSupplier<Watch>(() -> new WatchImpl(this.connectionManager));
        this.lockClient = new MemoizingClientSupplier<Lock>(() -> new LockImpl(this.connectionManager));
        this.electionClient = new MemoizingClientSupplier<Election>(() -> new ElectionImpl(this.connectionManager));
    }

    @Override
    public Auth getAuthClient() {
        return (Auth)this.authClient.get();
    }

    @Override
    public KV getKVClient() {
        return (KV)this.kvClient.get();
    }

    @Override
    public Cluster getClusterClient() {
        return (Cluster)this.clusterClient.get();
    }

    @Override
    public Maintenance getMaintenanceClient() {
        return (Maintenance)this.maintenanceClient.get();
    }

    @Override
    public Lease getLeaseClient() {
        return (Lease)this.leaseClient.get();
    }

    @Override
    public Watch getWatchClient() {
        return (Watch)this.watchClient.get();
    }

    @Override
    public Lock getLockClient() {
        return (Lock)this.lockClient.get();
    }

    @Override
    public Election getElectionClient() {
        return (Election)this.electionClient.get();
    }

    @Override
    public synchronized void close() {
        this.authClient.close();
        this.kvClient.close();
        this.clusterClient.close();
        this.maintenanceClient.close();
        this.leaseClient.close();
        this.watchClient.close();
        this.lockClient.close();
        this.electionClient.close();
        this.connectionManager.close();
    }
}

