/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.JdbcBaseDbContainer;
import io.ebean.docker.commands.SqlServerConfig;
import io.ebean.docker.container.Container;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;

public class SqlServerContainer
extends JdbcBaseDbContainer
implements Container {
    public static SqlServerContainer create(String version, Properties properties) {
        return new SqlServerContainer(new SqlServerConfig(version, properties));
    }

    public SqlServerContainer(SqlServerConfig config) {
        super(config);
    }

    @Override
    void createDatabase() {
        this.createRoleAndDatabase(false);
    }

    @Override
    void dropCreateDatabase() {
        this.createRoleAndDatabase(true);
    }

    private void createRoleAndDatabase(boolean withDrop) {
        try (Connection connection = this.config.createAdminConnection();){
            if (withDrop) {
                this.dropDatabaseIfExists(connection);
            }
            this.createDatabase(connection);
            this.createLogin(connection);
            this.createUser();
        }
        catch (SQLException e) {
            throw new RuntimeException("Error when creating database and role", e);
        }
    }

    private void createUser() {
        try (Connection dbConnection = this.dbConfig.createAdminConnection(this.dbConfig.jdbcUrl());){
            this.createUser(dbConnection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void createLogin(Connection connection) {
        if (!this.loginExists(connection, this.dbConfig.getUsername())) {
            this.createLogin(connection, this.dbConfig.getUsername(), this.dbConfig.getPassword());
        }
    }

    private void createUser(Connection dbConnection) {
        if (!this.userExists(dbConnection, this.dbConfig.getUsername())) {
            this.createUser(dbConnection, this.dbConfig.getUsername(), this.dbConfig.getUsername());
            this.grantOwner(dbConnection, this.dbConfig.getUsername());
        }
    }

    private void createDatabase(Connection connection) {
        if (!this.databaseExists(connection, this.dbConfig.getDbName())) {
            this.createDatabase(connection, this.dbConfig.getDbName());
        }
    }

    private void dropDatabaseIfExists(Connection connection) {
        if (this.databaseExists(connection, this.dbConfig.getDbName())) {
            this.dropDatabase(connection, this.dbConfig.getDbName());
        }
    }

    private void dropDatabase(Connection connection, String dbName) {
        this.sqlRun(connection, "drop database " + dbName);
    }

    private void createDatabase(Connection connection, String dbName) {
        this.sqlRun(connection, "create database " + dbName);
    }

    private void createLogin(Connection connection, String login, String pass) {
        this.sqlRun(connection, "create login " + login + " with password = '" + pass + "'");
    }

    private void createUser(Connection dbConnection, String roleName, String login) {
        this.sqlRun(dbConnection, "create user " + roleName + " for login " + login);
    }

    private void grantOwner(Connection dbConnection, String roleName) {
        this.sqlRun(dbConnection, "exec sp_addrolemember 'db_owner', " + roleName);
    }

    private boolean userExists(Connection dbConnection, String userName) {
        return this.sqlHasRow(dbConnection, "select 1 from sys.database_principals where name = '" + userName + "'");
    }

    private boolean loginExists(Connection connection, String roleName) {
        return this.sqlHasRow(connection, "select 1 from master.dbo.syslogins where loginname = '" + roleName + "'");
    }

    private boolean databaseExists(Connection connection, String dbName) {
        return this.sqlHasRow(connection, "select 1 from sys.databases where name='" + dbName + "'");
    }

    @Override
    protected ProcessBuilder runProcess() {
        List<String> args = this.dockerRun();
        args.add("-e");
        args.add("ACCEPT_EULA=Y");
        args.add("-e");
        args.add("SA_PASSWORD=" + this.dbConfig.getAdminPassword());
        if (!this.config.isDefaultCollation()) {
            if (this.config.isExplicitCollation()) {
                args.add("-e");
                args.add("MSSQL_COLLATION=" + this.dbConfig.getCollation());
            } else {
                args.add("-e");
                args.add("MSSQL_COLLATION=Latin1_General_100_BIN2");
            }
        }
        args.add(this.config.getImage());
        return this.createProcessBuilder(args);
    }
}

