/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.DbConfig;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HanaConfig
extends DbConfig {
    private static final Logger log = LoggerFactory.getLogger(HanaConfig.class);
    private String mountsDirectory;
    private URL passwordsUrl;
    private String instanceNumber;
    private boolean agreeToSapLicense;

    public HanaConfig(String version, Properties properties) {
        this(version);
        this.setProperties(properties);
        if (!Integer.toString(this.port).matches("\\d{5}")) {
            throw new IllegalArgumentException("Invalid port: " + this.port + ". The port must consist of exactly 5 digits.");
        }
        this.mountsDirectory = this.prop(properties, "mountsDirectory", "/data/dockermounts");
        if (!Files.isDirectory(Paths.get(this.mountsDirectory, new String[0]), new LinkOption[0])) {
            throw new IllegalArgumentException("The given mounts directory \"" + this.mountsDirectory + "\" doesn't exist or is not a directory");
        }
        try {
            this.passwordsUrl = new URL(this.prop(properties, "passwordsUrl", "file:///hana/mounts/passwords.json"));
        }
        catch (MalformedURLException e) {
            log.warn("Invalid passwords URL. Using default.", (Throwable)e);
            try {
                this.passwordsUrl = new URL("file:///hana/mounts/passwords.json");
            }
            catch (MalformedURLException e1) {
                log.debug("Invalid passwords URL. Can't happen.");
            }
        }
        this.instanceNumber = this.prop(properties, "instanceNumber", "90");
        if (!this.instanceNumber.matches("\\d{2}")) {
            throw new IllegalArgumentException("Invalid instance number: " + this.instanceNumber + ". The instance number must consist of exactly two digits.");
        }
        if (!"90".equals(this.instanceNumber)) {
            String portStr = Integer.toString(this.port);
            this.port = Integer.parseInt(portStr.substring(0, 1) + this.instanceNumber + portStr.substring(3));
        }
        this.agreeToSapLicense = this.checkLicenseAgreement(properties);
    }

    public HanaConfig(String version) {
        super("hana", 39017, 39017, version);
        this.image = "store/saplabs/hanaexpress:" + version;
        this.mountsDirectory = "/data/dockermounts";
        try {
            this.passwordsUrl = new URL("file:///hana/mounts/passwords.json");
        }
        catch (MalformedURLException e1) {
            log.debug("Invalid passwords URL. Can't happen.");
        }
        this.instanceNumber = "90";
        this.agreeToSapLicense = HanaConfig.checkLicenseAgreement();
        this.setAdminUser("SYSTEM");
        this.setAdminPassword("HXEHana1");
        this.setPassword("HXEHana1");
        this.setDbName("HXE");
        this.setMaxReadyAttempts(3000);
    }

    @Override
    public String jdbcUrl() {
        return "jdbc:sap://localhost:" + this.getPort() + "/?databaseName=" + this.getDbName();
    }

    public String getMountsDirectory() {
        return this.mountsDirectory;
    }

    public void setMountsDirectory(String mountsDirectory) {
        this.mountsDirectory = mountsDirectory;
    }

    public URL getPasswordsUrl() {
        return this.passwordsUrl;
    }

    public void setPasswordsUrl(URL passwordsUrl) {
        this.passwordsUrl = passwordsUrl;
    }

    public String getInstanceNumber() {
        return this.instanceNumber;
    }

    public void setInstanceNumber(String instanceNumber) {
        this.instanceNumber = instanceNumber;
    }

    public boolean isAgreeToSapLicense() {
        return this.agreeToSapLicense;
    }

    public void setAgreeToSapLicense(boolean agreeToSapLicense) {
        this.agreeToSapLicense = agreeToSapLicense;
    }

    public boolean checkLicenseAgreement(Properties properties) {
        String propertyValue = null;
        if (properties != null && (propertyValue = this.prop(properties, "agreeToSapLicense", null)) != null) {
            return Boolean.parseBoolean(propertyValue);
        }
        return HanaConfig.checkLicenseAgreement();
    }

    public static boolean checkLicenseAgreement() {
        String propertyValue = System.getProperty("hana.agreeToSapLicense");
        if (propertyValue != null) {
            return Boolean.parseBoolean(propertyValue);
        }
        propertyValue = System.getenv("hana.agreeToSapLicense");
        if (propertyValue != null) {
            return Boolean.parseBoolean(propertyValue);
        }
        return false;
    }
}

