/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.datasource.pool;

import io.ebean.datasource.DataSourcePool;
import io.ebean.datasource.PoolStatus;
import io.ebean.datasource.pool.ConnectionPool;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;

final class LambdaPool
implements DataSourcePool {
    private final ConnectionPool pool;

    LambdaPool(ConnectionPool pool) {
        this.pool = pool;
    }

    public Connection getConnection() throws SQLException {
        this.pool.checkLambdaIdle();
        return this.pool.getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        this.pool.checkLambdaIdle();
        return this.pool.getConnection(username, password);
    }

    public String name() {
        return this.pool.name();
    }

    public int size() {
        return this.pool.size();
    }

    public boolean isAutoCommit() {
        return this.pool.isAutoCommit();
    }

    public boolean isOnline() {
        return this.pool.isOnline();
    }

    public boolean isDataSourceUp() {
        return this.pool.isDataSourceUp();
    }

    public void online() throws SQLException {
        this.pool.online();
    }

    public void offline() {
        this.pool.offline();
    }

    public void shutdown() {
        this.pool.shutdown();
    }

    public PoolStatus status(boolean reset) {
        return this.pool.status(reset);
    }

    public SQLException dataSourceDownReason() {
        return this.pool.dataSourceDownReason();
    }

    public void setMaxSize(int max) {
        this.pool.setMaxSize(max);
    }

    public void setWarningSize(int warningSize) {
        this.pool.setWarningSize(warningSize);
    }

    public int getWarningSize() {
        return this.pool.getWarningSize();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.pool.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.pool.setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.pool.setLoginTimeout(seconds);
    }

    public int getLoginTimeout() throws SQLException {
        return this.pool.getLoginTimeout();
    }

    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.pool.getParentLogger();
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.pool.unwrap(iface);
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.pool.isWrapperFor(iface);
    }
}

