/*
 * Decompiled with CFR 0.152.
 */
package io.ebean;

import io.ebean.MergeOptions;
import java.util.LinkedHashSet;
import java.util.Set;

public class MergeOptionsBuilder {
    private static final MOptions DEFAULT_OPTIONS = new MOptions();
    private Set<String> paths = new LinkedHashSet<String>();
    private boolean clientGeneratedIds;
    private boolean deletePermanent;

    public static MergeOptions defaultOptions() {
        return DEFAULT_OPTIONS;
    }

    public MergeOptionsBuilder addPath(String path) {
        this.paths.add(path);
        return this;
    }

    public MergeOptionsBuilder setClientGeneratedIds() {
        this.clientGeneratedIds = true;
        return this;
    }

    public MergeOptionsBuilder setDeletePermanent() {
        this.deletePermanent = true;
        return this;
    }

    public MergeOptions build() {
        return new MOptions(this.paths, this.clientGeneratedIds, this.deletePermanent);
    }

    private static class MOptions
    implements MergeOptions {
        private final boolean clientGeneratedIds;
        private final boolean deletePermanent;
        private final Set<String> paths;

        private MOptions() {
            this.clientGeneratedIds = false;
            this.paths = new LinkedHashSet<String>();
            this.deletePermanent = false;
        }

        private MOptions(Set<String> paths, boolean clientGeneratedIds, boolean deletePermanent) {
            this.paths = paths;
            this.clientGeneratedIds = clientGeneratedIds;
            this.deletePermanent = deletePermanent;
        }

        @Override
        public Set<String> paths() {
            return this.paths;
        }

        @Override
        public boolean isClientGeneratedIds() {
            return this.clientGeneratedIds;
        }

        @Override
        public boolean isDeletePermanent() {
            return this.deletePermanent;
        }
    }
}

