/*
 * Decompiled with CFR 0.152.
 */
package io.ebean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Lists {
    private Lists() {
    }

    public static <T> List<List<T>> partition(List<T> source, int max) {
        int totalCount = source.size();
        if (totalCount == 0) {
            return Collections.emptyList();
        }
        if (totalCount <= max) {
            return List.of(source);
        }
        int numOfPartitions = (totalCount + max - 1) / max;
        ArrayList<List<T>> dest = new ArrayList<List<T>>(numOfPartitions);
        for (int i = 0; i < numOfPartitions; ++i) {
            int from = i * max;
            int to = Math.min(from + max, totalCount);
            dest.add(source.subList(from, to));
        }
        return dest;
    }
}

