/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.prometheus.config;

import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.project.Project;
import io.dekorate.prometheus.config.ServiceMonitorConfigBuilder;
import java.util.Map;
import java.util.Objects;

public class ServiceMonitorConfig
extends Configuration {
    private String port;
    private String path;
    private Integer interval;
    private Boolean honorLabels;

    public ServiceMonitorConfig() {
    }

    public ServiceMonitorConfig(Project project, Map<ConfigKey, Object> attributes, String port, String path, Integer interval, Boolean honorLabels) {
        super(project, attributes);
        this.port = port;
        this.path = path;
        this.interval = interval;
        this.honorLabels = honorLabels;
    }

    public String getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public Boolean getHonorLabels() {
        return this.honorLabels;
    }

    public boolean isHonorLabels() {
        return this.honorLabels != null && this.honorLabels != false;
    }

    public static ServiceMonitorConfigBuilder newServiceMonitorConfigBuilder() {
        return new ServiceMonitorConfigBuilder();
    }

    public static ServiceMonitorConfigBuilder newServiceMonitorConfigBuilderFromDefaults() {
        return (ServiceMonitorConfigBuilder)((ServiceMonitorConfigBuilder)((ServiceMonitorConfigBuilder)((ServiceMonitorConfigBuilder)new ServiceMonitorConfigBuilder().withPort("http")).withPath("/metrics")).withInterval(10)).withHonorLabels(false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceMonitorConfig that = (ServiceMonitorConfig)((Object)o);
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) {
            return false;
        }
        return !(this.honorLabels != null ? !this.honorLabels.equals(that.honorLabels) : that.honorLabels != null);
    }

    public int hashCode() {
        return Objects.hash(this.port, this.path, this.interval, this.honorLabels, super.hashCode());
    }
}

