/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.time;

import androidx.annotation.NonNull;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.internal.utils.TrackMap;
import com.otaliastudios.transcoder.internal.utils.TrackMapKt;
import com.otaliastudios.transcoder.time.TimeInterpolator;

public class SpeedTimeInterpolator
implements TimeInterpolator {
    private static final Logger LOG = new Logger("SpeedTimeInterpolator");
    private final double mFactor;
    private final TrackMap<TrackData> mTrackData = TrackMapKt.trackMapOf(new TrackData(), new TrackData());

    public SpeedTimeInterpolator(float factor) {
        if (factor <= 0.0f) {
            throw new IllegalArgumentException("Invalid speed factor: " + factor);
        }
        this.mFactor = factor;
    }

    public float getFactor(@NonNull TrackType type, long time) {
        return (float)this.mFactor;
    }

    @Override
    public long interpolate(@NonNull TrackType type, long time) {
        TrackData data = this.mTrackData.get(type);
        if (data.lastRealTime == Long.MIN_VALUE) {
            data.lastRealTime = time;
            data.lastCorrectedTime = time;
        } else {
            long realDelta = time - data.lastRealTime;
            long correctedDelta = (long)((double)realDelta / (double)this.getFactor(type, time));
            data.lastRealTime = time;
            data.lastCorrectedTime += correctedDelta;
        }
        LOG.v("Track:" + (Object)((Object)type) + " inputTime:" + time + " outputTime:" + data.lastCorrectedTime);
        return data.lastCorrectedTime;
    }

    private static class TrackData {
        private long lastRealTime = Long.MIN_VALUE;
        private long lastCorrectedTime = Long.MIN_VALUE;

        private TrackData() {
        }
    }
}

