/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.source;

import androidx.annotation.NonNull;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.source.DataSource;
import com.otaliastudios.transcoder.source.DataSourceWrapper;

public class TrimDataSource
extends DataSourceWrapper {
    private static final Logger LOG = new Logger("TrimDataSource");
    private final long trimStartUs;
    private final long trimEndUs;
    private long extraDurationUs = 0L;
    private long trimDurationUs = Long.MIN_VALUE;
    private boolean trimDone = false;

    public TrimDataSource(@NonNull DataSource source, long trimStartUs) {
        this(source, trimStartUs, 0L);
    }

    public TrimDataSource(@NonNull DataSource source, long trimStartUs, long trimEndUs) {
        super(source);
        if (trimStartUs < 0L || trimEndUs < 0L) {
            throw new IllegalArgumentException("Trim values cannot be negative.");
        }
        this.trimStartUs = trimStartUs;
        this.trimEndUs = trimEndUs;
    }

    @Override
    public boolean isInitialized() {
        return super.isInitialized() && this.trimDurationUs != Long.MIN_VALUE;
    }

    @Override
    public void deinitialize() {
        super.deinitialize();
        this.trimDurationUs = Long.MIN_VALUE;
        this.trimDone = false;
    }

    @Override
    public void initialize() {
        super.initialize();
        long duration = this.getSource().getDurationUs();
        if (this.trimStartUs + this.trimEndUs >= duration) {
            LOG.w("Trim values are too large! start=" + this.trimStartUs + ", end=" + this.trimEndUs + ", duration=" + duration);
            throw new IllegalArgumentException("Trim values cannot be greater than media duration.");
        }
        LOG.i("initialize(): duration=" + duration + " trimStart=" + this.trimStartUs + " trimEnd=" + this.trimEndUs + " trimDuration=" + (duration - this.trimStartUs - this.trimEndUs));
        this.trimDurationUs = duration - this.trimStartUs - this.trimEndUs;
    }

    @Override
    public long getDurationUs() {
        return this.trimDurationUs + this.extraDurationUs;
    }

    @Override
    public long getPositionUs() {
        return super.getPositionUs() - this.trimStartUs + this.extraDurationUs;
    }

    @Override
    public boolean canReadTrack(@NonNull TrackType type) {
        if (!this.trimDone && this.trimStartUs > 0L) {
            this.extraDurationUs = this.trimStartUs - this.getSource().seekTo(this.trimStartUs);
            LOG.i("canReadTrack(): extraDurationUs=" + this.extraDurationUs + " trimStartUs=" + this.trimStartUs + " source.seekTo(trimStartUs)=" + (this.extraDurationUs - this.trimStartUs));
            this.trimDone = true;
        }
        return super.canReadTrack(type);
    }

    @Override
    public boolean isDrained() {
        return super.isDrained() || this.getPositionUs() >= this.getDurationUs();
    }

    @Override
    public long seekTo(long desiredPositionUs) {
        long superDesiredUs = this.trimStartUs + desiredPositionUs;
        long superReceivedUs = this.getSource().seekTo(superDesiredUs);
        return superReceivedUs - this.trimStartUs;
    }
}

