/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.sink;

import android.media.MediaFormat;
import androidx.annotation.NonNull;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.utils.AvcCsdUtils;
import com.otaliastudios.transcoder.internal.utils.AvcSpsUtils;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.sink.InvalidOutputFormatException;
import java.nio.ByteBuffer;

class DefaultDataSinkChecks {
    private static final Logger LOG = new Logger("DefaultDataSinkChecks");

    DefaultDataSinkChecks() {
    }

    void checkOutputFormat(@NonNull TrackType type, @NonNull MediaFormat format) {
        if (type == TrackType.VIDEO) {
            this.checkVideoOutputFormat(format);
        } else if (type == TrackType.AUDIO) {
            this.checkAudioOutputFormat(format);
        }
    }

    private void checkVideoOutputFormat(@NonNull MediaFormat format) {
        String mime = format.getString("mime");
        if (!"video/avc".equals(mime)) {
            throw new InvalidOutputFormatException("Video codecs other than AVC is not supported, actual mime type: " + mime);
        }
        ByteBuffer spsBuffer = AvcCsdUtils.getSpsBuffer(format);
        byte profileIdc = AvcSpsUtils.getProfileIdc(spsBuffer);
        String profileName = AvcSpsUtils.getProfileName(profileIdc);
        if (profileIdc == 66) {
            LOG.i("Output H.264 profile: " + profileName);
        } else {
            LOG.w("Output H.264 profile: " + profileName + ". This might not be supported.");
        }
    }

    private void checkAudioOutputFormat(@NonNull MediaFormat format) {
        String mime = format.getString("mime");
        if (!"audio/mp4a-latm".equals(mime)) {
            throw new InvalidOutputFormatException("Audio codecs other than AAC is not supported, actual mime type: " + mime);
        }
    }
}

