/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.codec;

import android.media.MediaCodec;
import android.media.MediaFormat;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.Codecs;
import com.otaliastudios.transcoder.internal.codec.EncoderChannel;
import com.otaliastudios.transcoder.internal.codec.EncoderData;
import com.otaliastudios.transcoder.internal.data.WriterChannel;
import com.otaliastudios.transcoder.internal.data.WriterData;
import com.otaliastudios.transcoder.internal.pipeline.QueuedStep;
import com.otaliastudios.transcoder.internal.pipeline.State;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00012\u00020\u0003B\u001f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fB\u0019\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u000b\u0010\u0011J\u0016\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001cH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0002H\u0014J\u0010\u0010#\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0002H\u0014J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040%H\u0014J\b\u0010&\u001a\u00020!H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/otaliastudios/transcoder/internal/codec/Encoder;", "Lcom/otaliastudios/transcoder/internal/pipeline/QueuedStep;", "Lcom/otaliastudios/transcoder/internal/codec/EncoderData;", "Lcom/otaliastudios/transcoder/internal/codec/EncoderChannel;", "Lcom/otaliastudios/transcoder/internal/data/WriterData;", "Lcom/otaliastudios/transcoder/internal/data/WriterChannel;", "encoder", "Lcom/otaliastudios/transcoder/internal/Codecs$Codec;", "ownsCodecStart", "", "ownsCodecStop", "<init>", "(Lcom/otaliastudios/transcoder/internal/Codecs$Codec;ZZ)V", "codecs", "Lcom/otaliastudios/transcoder/internal/Codecs;", "type", "Lcom/otaliastudios/transcoder/common/TrackType;", "(Lcom/otaliastudios/transcoder/internal/Codecs;Lcom/otaliastudios/transcoder/common/TrackType;)V", "surface", "Lcom/otaliastudios/transcoder/internal/Codecs$Surface;", "getSurface", "()Lcom/otaliastudios/transcoder/internal/Codecs$Surface;", "channel", "getChannel", "()Lcom/otaliastudios/transcoder/internal/codec/Encoder;", "info", "Landroid/media/MediaCodec$BufferInfo;", "buffer", "Lkotlin/Pair;", "Ljava/nio/ByteBuffer;", "", "eosReceivedButNotEnqueued", "enqueueEos", "", "data", "enqueue", "drain", "Lcom/otaliastudios/transcoder/internal/pipeline/State;", "release", "lib_release"})
@SourceDebugExtension(value={"SMAP\nEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Encoder.kt\ncom/otaliastudios/transcoder/internal/codec/Encoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1#2:139\n*E\n"})
public final class Encoder
extends QueuedStep<EncoderData, EncoderChannel, WriterData, WriterChannel>
implements EncoderChannel {
    @NotNull
    private final Codecs.Codec encoder;
    private final boolean ownsCodecStop;
    @NotNull
    private final Encoder channel;
    @NotNull
    private MediaCodec.BufferInfo info;
    private boolean eosReceivedButNotEnqueued;

    public Encoder(@NotNull Codecs.Codec encoder, boolean ownsCodecStart, boolean ownsCodecStop) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        super(encoder.getSurface() == null ? "AudioEncoder" : "VideoEncoder");
        this.encoder = encoder;
        this.ownsCodecStop = ownsCodecStop;
        this.channel = this;
        this.info = new MediaCodec.BufferInfo();
        this.encoder.setLog(this.getLog());
        this.getLog().i("ownsStart=" + ownsCodecStart + " ownsStop=" + this.ownsCodecStop + " " + this.encoder.getState());
        if (ownsCodecStart) {
            this.encoder.getCodec().start();
        }
    }

    public Encoder(@NotNull Codecs codecs, @NotNull TrackType type) {
        Intrinsics.checkNotNullParameter((Object)codecs, (String)"codecs");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this(codecs.getEncoders().get(type), codecs.getOwnsEncoderStart().get(type), codecs.getOwnsEncoderStop().get(type));
    }

    @Override
    @Nullable
    public Codecs.Surface getSurface() {
        return this.encoder.getSurface();
    }

    @Override
    @NotNull
    public Encoder getChannel() {
        return this.channel;
    }

    @Override
    @Nullable
    public Pair<ByteBuffer, Integer> buffer() {
        return this.encoder.getInputBuffer();
    }

    @Override
    protected void enqueueEos(@NotNull EncoderData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (this.getSurface() == null) {
            if (this.ownsCodecStop) {
                this.encoder.getCodec().queueInputBuffer(data.getId(), 0, 0, 0L, 4);
                Codecs.Codec codec = this.encoder;
                int n = codec.getDequeuedInputs();
                codec.setDequeuedInputs(n + -1);
            } else {
                this.eosReceivedButNotEnqueued = true;
                ByteBuffer byteBuffer = data.getBuffer();
                Intrinsics.checkNotNull((Object)byteBuffer);
                this.encoder.holdInputBuffer(byteBuffer, data.getId());
            }
        } else if (!this.ownsCodecStop) {
            this.eosReceivedButNotEnqueued = true;
        } else {
            this.encoder.getCodec().signalEndOfInputStream();
        }
    }

    @Override
    protected void enqueue(@NotNull EncoderData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (this.getSurface() != null) {
            return;
        }
        ByteBuffer byteBuffer = data.getBuffer();
        if (byteBuffer == null) {
            boolean bl = false;
            String string = "Audio should always pass a buffer to Encoder.";
            throw new IllegalArgumentException(string.toString());
        }
        ByteBuffer buffer = byteBuffer;
        this.encoder.getCodec().queueInputBuffer(data.getId(), buffer.position(), buffer.remaining(), data.getTimeUs(), 0);
        Codecs.Codec codec = this.encoder;
        int n = codec.getDequeuedInputs();
        codec.setDequeuedInputs(n + -1);
    }

    @Override
    @NotNull
    protected State<WriterData> drain() {
        long timeoutUs = this.eosReceivedButNotEnqueued ? 5000L : 100L;
        int result = this.encoder.getCodec().dequeueOutputBuffer(this.info, timeoutUs);
        return switch (result) {
            case -1 -> {
                if (this.eosReceivedButNotEnqueued) {
                    this.getLog().i("Sending fake Eos. " + this.encoder.getState());
                    ByteBuffer buffer = ByteBuffer.allocateDirect(0);
                    Intrinsics.checkNotNull((Object)buffer);
                    yield new State.Eos<WriterData>(new WriterData(buffer, 0L, 0, (Function0<Unit>)((Function0)Encoder::drain$lambda$1)));
                }
                this.getLog().i("Can't dequeue output buffer: INFO_TRY_AGAIN_LATER");
                yield new State.Retry(true);
            }
            case -2 -> {
                this.getLog().i("INFO_OUTPUT_FORMAT_CHANGED! format=" + this.encoder.getCodec().getOutputFormat());
                WriterChannel v1 = (WriterChannel)this.getNext();
                MediaFormat v2 = this.encoder.getCodec().getOutputFormat();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getOutputFormat(...)");
                v1.handleFormat(v2);
                yield this.drain();
            }
            case -3 -> this.drain();
            default -> {
                boolean isConfig;
                boolean v3 = isConfig = (this.info.flags & 2) != 0;
                if (isConfig) {
                    this.encoder.getCodec().releaseOutputBuffer(result, false);
                    yield this.drain();
                }
                Codecs.Codec var5_5 = this.encoder;
                int var6_7 = var5_5.getDequeuedOutputs();
                var5_5.setDequeuedOutputs(var6_7 + 1);
                boolean isEos = (this.info.flags & 4) != 0;
                int flags = this.info.flags & 0xFFFFFFFB;
                ByteBuffer v4 = this.encoder.getCodec().getOutputBuffer(result);
                if (v4 == null) {
                    boolean $i$a$-checkNotNull-Encoder$drain$buffer$1 = false;
                    String var9_9 = "outputBuffer(" + result + ") should not be null.";
                    throw new IllegalStateException(var9_9.toString());
                }
                ByteBuffer buffer = v4;
                long timeUs = this.info.presentationTimeUs;
                buffer.clear();
                buffer.limit(this.info.offset + this.info.size);
                buffer.position(this.info.offset);
                WriterData data = new WriterData(buffer, timeUs, flags, (Function0<Unit>)((Function0)() -> Encoder.drain$lambda$3(this, result)));
                yield isEos ? (State.Ok)new State.Eos<WriterData>(data) : new State.Ok(data);
            }
        };
    }

    @Override
    public void release() {
        this.getLog().i("release(): ownsStop=" + this.ownsCodecStop + " " + this.encoder.getState());
        if (this.ownsCodecStop) {
            this.encoder.getCodec().stop();
        }
    }

    private static final Unit drain$lambda$1() {
        return Unit.INSTANCE;
    }

    private static final Unit drain$lambda$3(Encoder this$0, int $result) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.encoder.getCodec().releaseOutputBuffer($result, false);
        Codecs.Codec codec = this$0.encoder;
        int n = codec.getDequeuedOutputs();
        codec.setDequeuedOutputs(n + -1);
        return Unit.INSTANCE;
    }
}

