/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.kafka;

import io.debezium.testing.system.TestUtils;
import io.debezium.testing.system.tools.WaitConditions;
import io.debezium.testing.system.tools.kafka.KafkaController;
import io.debezium.testing.system.tools.kafka.docker.KafkaContainer;
import io.debezium.testing.system.tools.kafka.docker.ZookeeperContainer;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerKafkaController
implements KafkaController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerKafkaController.class);
    private final KafkaContainer kafkaContainer;
    private ZookeeperContainer zookeeperContainer;

    public KafkaContainer getKafkaContainer() {
        return this.kafkaContainer;
    }

    public void setZookeeperContainer(ZookeeperContainer zookeeperContainer) {
        this.zookeeperContainer = zookeeperContainer;
    }

    public DockerKafkaController(KafkaContainer container) {
        this.kafkaContainer = container;
    }

    @Override
    public String getPublicBootstrapAddress() {
        return this.kafkaContainer.getPublicBootstrapAddress();
    }

    @Override
    public String getBootstrapAddress() {
        return this.kafkaContainer.getBootstrapAddress();
    }

    @Override
    public String getTlsBootstrapAddress() {
        return null;
    }

    @Override
    public boolean undeploy() {
        this.kafkaContainer.stop();
        if (TestUtils.shouldKRaftBeUsed()) {
            return !this.kafkaContainer.isRunning();
        }
        this.zookeeperContainer.stop();
        return !this.zookeeperContainer.isRunning() && !this.kafkaContainer.isRunning();
    }

    @Override
    public void waitForCluster() {
        Awaitility.await().atMost(WaitConditions.scaled(5L), TimeUnit.MINUTES).until(() -> ((KafkaContainer)this.kafkaContainer).isRunning());
    }
}

