/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.kafka;

import io.debezium.testing.system.TestUtils;
import io.debezium.testing.system.tools.AbstractDockerDeployer;
import io.debezium.testing.system.tools.Deployer;
import io.debezium.testing.system.tools.kafka.DockerKafkaController;
import io.debezium.testing.system.tools.kafka.docker.KafkaContainer;
import io.debezium.testing.system.tools.kafka.docker.ZookeeperContainer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.lifecycle.Startables;

public class DockerKafkaDeployer
extends AbstractDockerDeployer<DockerKafkaController, KafkaContainer>
implements Deployer<DockerKafkaController> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerKafkaDeployer.class);

    public DockerKafkaDeployer(KafkaContainer container) {
        super(container);
    }

    @Override
    protected DockerKafkaController getController(KafkaContainer container) {
        LOGGER.info("Deploying Kafka container");
        return new DockerKafkaController(container);
    }

    @Override
    public DockerKafkaController deploy() {
        DockerKafkaController controller;
        if (!TestUtils.shouldKRaftBeUsed()) {
            LOGGER.info("Using Kafka in Zookeeper mode");
            LOGGER.info("Deploying Zookeeper container");
            ZookeeperContainer zookeeperContainer = (ZookeeperContainer)new ZookeeperContainer().withNetwork(((KafkaContainer)this.container).getNetwork());
            ((KafkaContainer)this.container).withZookeeper(zookeeperContainer);
            Startables.deepStart(Stream.of(new GenericContainer[]{zookeeperContainer, this.container})).join();
            controller = this.getController((KafkaContainer)this.container);
            controller.setZookeeperContainer(zookeeperContainer);
        } else {
            LOGGER.info("Using Kafka in KRaft mode");
            controller = this.getController((KafkaContainer)this.container);
        }
        return controller;
    }

    public static class Builder
    extends AbstractDockerDeployer.DockerBuilder<Builder, KafkaContainer, DockerKafkaDeployer> {
        public Builder() {
            this(new KafkaContainer());
        }

        public Builder(KafkaContainer container) {
            super(container);
        }

        @Override
        public DockerKafkaDeployer build() {
            return new DockerKafkaDeployer((KafkaContainer)this.container);
        }
    }
}

