/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.registry.builders;

import io.apicurio.registry.operator.api.v1.model.ApicurioRegistry;
import io.apicurio.registry.operator.api.v1.model.ApicurioRegistryBuilder;
import io.apicurio.registry.operator.api.v1.model.ApicurioRegistryFluent;
import io.apicurio.registry.operator.api.v1.model.ApicurioRegistrySpecFluent;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.ConfigurationFluent;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.kafkasql.Security;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.kafkasql.SecurityBuilder;
import io.apicurio.registry.operator.api.v1.model.apicurioregistryspec.configuration.kafkasql.security.TlsBuilder;
import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.fabric8.FabricBuilderWrapper;
import io.debezium.testing.system.tools.kafka.builders.FabricKafkaConnectBuilder;

public class FabricApicurioBuilder
extends FabricBuilderWrapper<FabricApicurioBuilder, ApicurioRegistryBuilder, ApicurioRegistry> {
    private static final String DEFAULT_PERSISTENCE_TYPE = "kafkasql";

    protected FabricApicurioBuilder(ApicurioRegistryBuilder builder) {
        super(builder);
    }

    @Override
    public ApicurioRegistry build() {
        return ((ApicurioRegistryBuilder)this.builder).build();
    }

    private static FabricApicurioBuilder base() {
        ApicurioRegistryBuilder builder = (ApicurioRegistryBuilder)((ApicurioRegistryBuilder)((ApicurioRegistryFluent.MetadataNested)new ApicurioRegistryBuilder().withNewMetadata().withName("debezium-registry")).endMetadata()).withNewSpec().endSpec();
        return new FabricApicurioBuilder(builder);
    }

    public static FabricApicurioBuilder baseKafkaSql(String bootstrap) {
        return FabricApicurioBuilder.base().withKafkaSqlConfiguration(bootstrap);
    }

    public FabricApicurioBuilder withKafkaSqlConfiguration(String bootstrap) {
        ((ApicurioRegistryFluent.SpecNested)((ApicurioRegistrySpecFluent.ConfigurationNested)((ConfigurationFluent.KafkasqlNested)((ApicurioRegistrySpecFluent.ConfigurationNested)((ApicurioRegistrySpecFluent.ConfigurationNested)((ApicurioRegistryBuilder)this.builder).editSpec().withNewConfiguration().withLogLevel(ConfigProperties.APICURIO_LOG_LEVEL)).withPersistence(DEFAULT_PERSISTENCE_TYPE)).withNewKafkasql().withBootstrapServers(bootstrap)).endKafkasql()).endConfiguration()).endSpec();
        if (ConfigProperties.APICURIO_TLS_ENABLED) {
            this.withTls();
        }
        return (FabricApicurioBuilder)this.self();
    }

    public FabricApicurioBuilder withTls() {
        ((ApicurioRegistryFluent.SpecNested)((ApicurioRegistrySpecFluent.ConfigurationNested)((ConfigurationFluent.KafkasqlNested)((ApicurioRegistryBuilder)this.builder).editSpec().editConfiguration().editKafkasql().withSecurity(this.getTlsSpec())).endKafkasql()).endConfiguration()).endSpec();
        return (FabricApicurioBuilder)this.self();
    }

    private Security getTlsSpec() {
        return ((SecurityBuilder)new SecurityBuilder().withTls(((TlsBuilder)((TlsBuilder)new TlsBuilder().withKeystoreSecretName(FabricKafkaConnectBuilder.KAFKA_CLIENT_CERT_SECRET)).withTruststoreSecretName(FabricKafkaConnectBuilder.KAFKA_CERT_SECRET)).build())).build();
    }
}

