/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.kafka.docker;

import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.WaitConditions;
import java.time.Duration;
import org.testcontainers.containers.GenericContainer;

public class ZookeeperContainer
extends GenericContainer<ZookeeperContainer> {
    public static final String ZOOKEEPER_COMMAND = "zookeeper";
    public static final int ZOOKEEPER_PORT_CLIENT = 2181;

    public ZookeeperContainer(String containerImageName) {
        super(containerImageName);
        this.defaultConfig();
    }

    public ZookeeperContainer() {
        this(ConfigProperties.DOCKER_IMAGE_KAFKA_RHEL);
    }

    public String serverAddress() {
        return (String)this.getNetworkAliases().get(0) + ":2181";
    }

    private void defaultConfig() {
        this.withExposedPorts(new Integer[]{2181});
        this.withCommand(ZOOKEEPER_COMMAND);
        this.withStartupTimeout(Duration.ofMinutes(WaitConditions.scaled(1L)));
    }
}

