/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases.mongodb.sharded;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.OpenShiftUtils;
import io.debezium.testing.system.tools.databases.mongodb.sharded.MongoShardedUtil;
import io.debezium.testing.system.tools.databases.mongodb.sharded.OcpMongoDeploymentManager;
import io.debezium.testing.system.tools.databases.mongodb.sharded.OcpMongoReplicaSetMember;
import io.debezium.testing.system.tools.databases.mongodb.sharded.componentproviders.OcpConfigServerModelProvider;
import io.debezium.testing.system.tools.databases.mongodb.sharded.componentproviders.OcpShardModelProvider;
import io.debezium.testing.system.tools.databases.mongodb.sharded.freemarker.FreemarkerConfiguration;
import io.debezium.testing.system.tools.databases.mongodb.sharded.freemarker.InitReplicaSetModel;
import io.fabric8.openshift.client.OpenShiftClient;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.lifecycle.Startable;

public class OcpMongoReplicaSet
implements Startable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpMongoReplicaSet.class);
    private final String name;
    private final boolean configServer;
    private final int memberCount;
    private boolean authRequired = false;
    private final String rootUserName;
    private final String rootPassword;
    private boolean started = false;
    private final OpenShiftClient ocp;
    private final OpenShiftUtils ocpUtil;
    private final String project;
    private final boolean useInternalAuth;
    private final int shardNum;
    private final List<OcpMongoReplicaSetMember> members;

    public OcpMongoReplicaSet(String name, boolean configServer, int memberCount, String rootUserName, String rootPassword, OpenShiftClient ocp, String project, boolean useInternalAuth, int shardNum) {
        this.name = name;
        this.configServer = configServer;
        this.memberCount = memberCount;
        this.authRequired = false;
        this.rootUserName = rootUserName;
        this.rootPassword = rootPassword;
        this.ocp = ocp;
        this.project = project;
        this.useInternalAuth = useInternalAuth;
        this.shardNum = shardNum;
        this.ocpUtil = new OpenShiftUtils(ocp);
        this.members = MongoShardedUtil.intRange(memberCount).stream().map(i -> {
            if (configServer) {
                return OcpMongoReplicaSetMember.builder().withDeployment(OcpConfigServerModelProvider.configServerDeployment(i)).withService(OcpConfigServerModelProvider.configServerService(i)).withServiceUrl(this.getConfigServerServiceName((int)i)).withOcp(ocp).withProject(project).withReplicaNum((int)i).build();
            }
            return OcpMongoReplicaSetMember.builder().withDeployment(OcpShardModelProvider.shardDeployment(shardNum, i)).withService(OcpShardModelProvider.shardService(shardNum, i)).withServiceUrl(this.getShardReplicaServiceName((int)i)).withOcp(ocp).withProject(project).withReplicaNum((int)i).build();
        }).collect(Collectors.toList());
    }

    public String getReplicaSetFullName() {
        return this.name + "/" + this.members.stream().map(OcpMongoDeploymentManager::getServiceUrl).collect(Collectors.joining(","));
    }

    public void start() {
        if (this.started) {
            return;
        }
        if (this.useInternalAuth) {
            this.members.forEach(m -> MongoShardedUtil.addKeyFileToDeployment(m.getDeployment()));
        }
        LOGGER.info("[{}] Starting {} node replica set...", (Object)this.name, (Object)this.memberCount);
        this.members.parallelStream().forEach(m -> {
            m.start();
            this.ocpUtil.waitForPods(this.project, m.getDeployment().getMetadata().getLabels());
        });
        LOGGER.info("[{}] Initializing replica set...", (Object)this.name);
        try {
            OpenShiftUtils.CommandOutputs output = this.executeMongosh(this.getInitRsCommand(), false);
            if (!output.getStdOut().contains("is primary result:  true")) {
                throw new IllegalStateException("Replicaset initialization failed" + output);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.rootUserName) && StringUtils.isNotEmpty((CharSequence)this.rootPassword)) {
                this.executeMongosh(MongoShardedUtil.createRootUserCommand(this.rootUserName, this.rootPassword), false);
                this.authRequired = true;
            }
            if (!this.configServer) {
                this.executeMongosh("db.adminCommand({ setParameter: 1, orphanCleanupDelaySecs: 60 });", false);
            }
        }
        catch (TemplateException | IOException e) {
            throw new RuntimeException(e);
        }
        this.started = true;
    }

    public void stop() {
        this.members.parallelStream().forEach(OcpMongoDeploymentManager::stop);
    }

    public String getName() {
        return this.name;
    }

    public int getShardNum() {
        return this.shardNum;
    }

    public void waitForStopped() {
        this.members.parallelStream().forEach(OcpMongoDeploymentManager::waitForStopped);
    }

    public OpenShiftUtils.CommandOutputs executeMongosh(String command, boolean debugLogs) {
        return MongoShardedUtil.executeMongoShOnPod(this.ocpUtil, this.project, this.members.get(0).getDeployment(), this.getLocalhostConnectionString(), command, debugLogs);
    }

    private String getLocalhostConnectionString() {
        StringBuilder builder = new StringBuilder("mongodb://");
        if (this.authRequired) {
            builder.append(URLEncoder.encode(this.rootUserName, StandardCharsets.UTF_8)).append(":").append(URLEncoder.encode(this.rootPassword, StandardCharsets.UTF_8)).append("@");
        }
        String host = "localhost:" + this.getPort();
        builder.append(host).append("/?");
        if (this.authRequired) {
            builder.append("&").append("authSource=admin");
        }
        return builder.toString();
    }

    private int getPort() {
        return this.configServer ? 27019 : 27018;
    }

    private String getInitRsCommand() throws IOException, TemplateException {
        StringWriter writer = new StringWriter();
        Template template = new FreemarkerConfiguration().getFreemarkerConfiguration().getTemplate("init-rs.js");
        template.process((Object)new InitReplicaSetModel(this.members, this.name, this.configServer), (Writer)writer);
        return writer.toString();
    }

    private String getShardReplicaServiceName(int replicaNum) {
        return String.format("%s%dr%d.%s.svc.cluster.local:%d", "mongo-shard", this.shardNum, replicaNum, ConfigProperties.OCP_PROJECT_MONGO, 27018);
    }

    private String getConfigServerServiceName(int replicaNum) {
        return String.format("%s.%s.svc.cluster.local:%d", OcpConfigServerModelProvider.getConfigServerName(replicaNum), ConfigProperties.OCP_PROJECT_MONGO, 27019);
    }

    public static OcpMongoReplicaSetBuilder builder() {
        return new OcpMongoReplicaSetBuilder();
    }

    public static final class OcpMongoReplicaSetBuilder {
        private String name;
        private boolean configServer;
        private int memberCount;
        private String rootUserName;
        private String rootPassword;
        private OpenShiftClient ocp;
        private String project;
        private boolean useInternalAuth;
        private int shardNum;

        private OcpMongoReplicaSetBuilder() {
        }

        public OcpMongoReplicaSetBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public OcpMongoReplicaSetBuilder withConfigServer(boolean configServer) {
            this.configServer = configServer;
            return this;
        }

        public OcpMongoReplicaSetBuilder withMemberCount(int memberCount) {
            this.memberCount = memberCount;
            return this;
        }

        public OcpMongoReplicaSetBuilder withRootUserName(String rootUserName) {
            this.rootUserName = rootUserName;
            return this;
        }

        public OcpMongoReplicaSetBuilder withRootPassword(String rootPassword) {
            this.rootPassword = rootPassword;
            return this;
        }

        public OcpMongoReplicaSetBuilder withOcp(OpenShiftClient ocp) {
            this.ocp = ocp;
            return this;
        }

        public OcpMongoReplicaSetBuilder withProject(String project) {
            this.project = project;
            return this;
        }

        public OcpMongoReplicaSetBuilder withUseInternalAuth(boolean useInternalAuth) {
            this.useInternalAuth = useInternalAuth;
            return this;
        }

        public OcpMongoReplicaSetBuilder withShardNum(int shardNum) {
            this.shardNum = shardNum;
            return this;
        }

        public OcpMongoReplicaSet build() {
            return new OcpMongoReplicaSet(this.name, this.configServer, this.memberCount, this.rootUserName, this.rootPassword, this.ocp, this.project, this.useInternalAuth, this.shardNum);
        }
    }
}

