/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases;

import io.debezium.testing.system.tools.OpenShiftUtils;
import io.debezium.testing.system.tools.WaitConditions;
import io.debezium.testing.system.tools.databases.DatabaseClient;
import io.debezium.testing.system.tools.databases.DatabaseController;
import io.debezium.testing.system.tools.databases.DatabaseExecListener;
import io.debezium.testing.system.tools.databases.DatabaseInitListener;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.Execable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorChannelable;
import io.fabric8.openshift.client.OpenShiftClient;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOcpDatabaseController<C extends DatabaseClient<?, ?>>
implements DatabaseController<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOcpDatabaseController.class);
    protected final OpenShiftClient ocp;
    protected final String project;
    protected final OpenShiftUtils ocpUtils;
    protected Deployment deployment;
    protected String name;
    protected List<Service> services;

    public AbstractOcpDatabaseController(Deployment deployment, List<Service> services, OpenShiftClient ocp) {
        this.deployment = deployment;
        this.name = deployment.getMetadata().getName();
        this.project = deployment.getMetadata().getNamespace();
        this.services = services;
        this.ocp = ocp;
        this.ocpUtils = new OpenShiftUtils(ocp);
    }

    private Service getService() {
        return (Service)((ServiceResource)((NonNamespaceOperation)this.ocp.services().inNamespace(this.project)).withName(this.deployment.getMetadata().getName())).get();
    }

    @Override
    public void reload() throws InterruptedException {
        LOGGER.info("Removing all pods of '" + this.name + "' deployment in namespace '" + this.project + "'");
        this.ocpUtils.scaleDeploymentToZero(this.deployment);
        LOGGER.info("Restoring all pods of '" + this.name + "' deployment in namespace '" + this.project + "'");
        ((RollableScalableResource)((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).withName(this.name)).scale(1);
    }

    @Override
    public String getDatabaseHostname() {
        return this.getService().getMetadata().getName() + "." + this.project + ".svc.cluster.local";
    }

    @Override
    public int getDatabasePort() {
        return this.getOriginalDatabasePort();
    }

    @Override
    public String getPublicDatabaseHostname() {
        return this.getDatabaseHostname();
    }

    @Override
    public int getPublicDatabasePort() {
        return this.getDatabasePort();
    }

    @Override
    public void initialize() throws InterruptedException {
        LOGGER.info("Removed port forward");
    }

    protected void executeInitCommand(Deployment deployment, String ... commands) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        String containerName = (String)deployment.getMetadata().getLabels().get("app");
        try (ExecWatch ignored = (ExecWatch)((Execable)this.prepareExec(deployment).usingListener((Object)new DatabaseInitListener(containerName, latch))).exec((Object[])commands);){
            LOGGER.info("Waiting until database is initialized");
            latch.await(WaitConditions.scaled(1L), TimeUnit.MINUTES);
        }
    }

    protected void executeCommand(Deployment deployment, String ... commands) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        try (ExecWatch ignored = (ExecWatch)((Execable)this.prepareExec(deployment).usingListener((Object)new DatabaseExecListener(deployment.getMetadata().getName(), latch))).exec((Object[])commands);){
            LOGGER.info("Waiting on " + deployment.getMetadata().getName() + " for commands " + Arrays.toString(commands));
            latch.await(WaitConditions.scaled(1L), TimeUnit.MINUTES);
        }
    }

    private TtyExecErrorChannelable<String, OutputStream, PipedInputStream, ExecWatch> prepareExec(Deployment deployment) {
        List<Pod> pods = this.ocpUtils.podsForDeployment(deployment);
        if (pods.size() > 1) {
            throw new IllegalArgumentException("Executing command on deployment scaled to more than 1");
        }
        Pod pod = pods.get(0);
        return (TtyExecErrorChannelable)((ContainerResource)this.getPodResource(pod).inContainer((Object)((String)pod.getMetadata().getLabels().get("app")))).writingError((Object)System.err);
    }

    private PodResource<Pod> getPodResource(Pod pod) {
        return (PodResource)((NonNamespaceOperation)this.ocp.pods().inNamespace(this.project)).withName(pod.getMetadata().getName());
    }

    private int getOriginalDatabasePort() {
        return this.getService().getSpec().getPorts().stream().filter(p -> p.getName().equals("db")).findAny().get().getPort();
    }
}

