/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms.scripting;

import com.dylibso.chicory.wasm.Parser;
import io.debezium.DebeziumException;
import io.debezium.transforms.scripting.Engine;
import io.debezium.transforms.scripting.RecordHeader;
import io.debezium.transforms.scripting.wasm.ChicoryEngine;
import java.net.URI;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.header.Header;

public class WasmEngine
implements Engine {
    private boolean aot;
    private String expression;
    private ChicoryEngine engine;

    @Override
    public void configure(String language, String expression) {
        Objects.requireNonNull(language);
        Objects.requireNonNull(expression);
        this.expression = expression;
        switch (language) {
            case "chicory": {
                this.aot = true;
                break;
            }
            case "chicory-interpreter": {
                this.aot = false;
                break;
            }
            default: {
                throw new DebeziumException("Attempted to use unsupported Wasm Engine: '" + language + "', currently we support 'chicory'");
            }
        }
        this.engine = ChicoryEngine.builder().withAot(this.aot).withWasmModule(Parser.parse((Path)Path.of(URI.create(expression)))).build();
    }

    protected Map<String, Object> getBindings(ConnectRecord<?> record) {
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put("key", this.key(record));
        bindings.put("value", this.value(record));
        bindings.put("keySchema", record.keySchema());
        bindings.put("valueSchema", record.valueSchema());
        bindings.put("topic", record.topic());
        bindings.put("header", this.headers(record));
        return bindings;
    }

    protected Object key(ConnectRecord<?> record) {
        return record.key();
    }

    protected Object value(ConnectRecord<?> record) {
        return record.value();
    }

    protected RecordHeader header(Header header) {
        return new RecordHeader(header.schema(), header.value());
    }

    protected Object headers(ConnectRecord<?> record) {
        return this.doHeaders(record);
    }

    protected Map<String, RecordHeader> doHeaders(ConnectRecord<?> record) {
        HashMap<String, RecordHeader> headers = new HashMap<String, RecordHeader>();
        for (Header header : record.headers()) {
            headers.put(header.key(), this.header(header));
        }
        return headers;
    }

    @Override
    public <T> T eval(ConnectRecord<?> record, Class<T> type) {
        Map<String, Object> bindings = this.getBindings(record);
        try {
            Object result = this.engine.eval(bindings);
            if (result == null || type.isAssignableFrom(result.getClass())) {
                return (T)result;
            }
            throw new DebeziumException("Value '" + String.valueOf(result) + "' returned by the expression is not a " + type.getSimpleName());
        }
        catch (Exception e) {
            throw new DebeziumException("Error while evaluating wasm file '" + this.expression + "' for record '" + String.valueOf(record) + "'", (Throwable)e);
        }
    }
}

