/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms.scripting;

import io.debezium.DebeziumException;
import io.debezium.transforms.scripting.Engine;
import io.debezium.transforms.scripting.RecordHeader;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.header.Header;

public class Jsr223Engine
implements Engine {
    private String expression;
    private CompiledScript script;
    protected ScriptEngine engine;

    @Override
    public void configure(String language, String expression) {
        this.expression = expression;
        ScriptEngineManager factory = new ScriptEngineManager();
        this.engine = factory.getEngineByName(language);
        if (this.engine == null) {
            throw new DebeziumException("Implementation of language '" + language + "' not found on the classpath");
        }
        this.configureEngine();
        if (this.engine instanceof Compilable) {
            try {
                this.script = ((Compilable)((Object)this.engine)).compile(expression);
            }
            catch (ScriptException e) {
                throw new DebeziumException((Throwable)e);
            }
        }
    }

    protected void configureEngine() {
    }

    protected Bindings getBindings(ConnectRecord<?> record) {
        Bindings bindings = this.engine.createBindings();
        bindings.put("key", this.key(record));
        bindings.put("value", this.value(record));
        bindings.put("keySchema", (Object)record.keySchema());
        bindings.put("valueSchema", (Object)record.valueSchema());
        bindings.put("topic", (Object)record.topic());
        bindings.put("header", this.headers(record));
        return bindings;
    }

    protected Object key(ConnectRecord<?> record) {
        return record.key();
    }

    protected Object value(ConnectRecord<?> record) {
        return record.value();
    }

    protected RecordHeader header(Header header) {
        return new RecordHeader(header.schema(), header.value());
    }

    protected Object headers(ConnectRecord<?> record) {
        return this.doHeaders(record);
    }

    protected Map<String, RecordHeader> doHeaders(ConnectRecord<?> record) {
        HashMap<String, RecordHeader> headers = new HashMap<String, RecordHeader>();
        for (Header header : record.headers()) {
            headers.put(header.key(), this.header(header));
        }
        return headers;
    }

    @Override
    public <T> T eval(ConnectRecord<?> record, Class<T> type) {
        Bindings bindings = this.getBindings(record);
        try {
            Object result;
            Object object = result = this.script != null ? this.script.eval(bindings) : this.engine.eval(this.expression, bindings);
            if (result == null || type.isAssignableFrom(result.getClass())) {
                return (T)result;
            }
            throw new DebeziumException("Value '" + result + "' returned by the expression is not a " + type.getSimpleName());
        }
        catch (Exception e) {
            throw new DebeziumException("Error while evaluating expression '" + this.expression + "' for record '" + record + "'", (Throwable)e);
        }
    }
}

